/*
 * Decompiled with CFR 0.152.
 */
package org.pointyware.disco.training.data;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.pointyware.disco.training.data.ExerciseRepository;
import org.pointyware.disco.training.data.Problem;
import org.pointyware.disco.training.data.SpiralExerciseGenerator;
import org.pointyware.disco.training.data.XorExerciseGenerator;
import org.pointyware.disco.training.entities.Exercise;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/pointyware/disco/training/data/ExerciseRepositoryImpl;", "Lorg/pointyware/disco/training/data/ExerciseRepository;", "<init>", "()V", "getExercises", "", "Lorg/pointyware/disco/training/entities/Exercise;", "problem", "Lorg/pointyware/disco/training/data/Problem;", "feature-training"})
@StabilityInferred(parameters=1)
public final class ExerciseRepositoryImpl
implements ExerciseRepository {
    public static final int $stable;

    @Override
    @NotNull
    public List<Exercise> getExercises(@NotNull Problem problem) {
        List<Exercise> list;
        Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
        Problem problem2 = problem;
        if (problem2 instanceof Problem.XorProblem) {
            list = new XorExerciseGenerator((Problem.XorProblem)problem).generate();
        } else if (problem2 instanceof Problem.SpiralClassificationProblem) {
            list = new SpiralExerciseGenerator((Problem.SpiralClassificationProblem)problem, 0, 2, null).generate();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }
}

