/*
 * Decompiled with CFR 0.152.
 */
package org.pointyware.disco.training.entities.optimizers;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.pointyware.disco.training.entities.Exercise;
import org.pointyware.disco.training.entities.optimizers.GradientDescent;
import org.pointyware.disco.training.entities.optimizers.LearningRateSchedule;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\"\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lorg/pointyware/disco/training/entities/optimizers/StochasticGradientDescent;", "Lorg/pointyware/disco/training/entities/optimizers/GradientDescent;", "batchSize", "", "learningRate", "Lorg/pointyware/disco/training/entities/optimizers/LearningRateSchedule;", "entropy", "Lkotlin/random/Random;", "discardExtras", "", "<init>", "(ILorg/pointyware/disco/training/entities/optimizers/LearningRateSchedule;Lkotlin/random/Random;Z)V", "getBatchSize", "()I", "getDiscardExtras", "()Z", "batch", "", "Lorg/pointyware/disco/training/entities/Exercise;", "cases", "feature-training"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nStochasticGradientDescent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StochasticGradientDescent.kt\norg/pointyware/disco/training/entities/optimizers/StochasticGradientDescent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1#2:44\n*E\n"})
public final class StochasticGradientDescent
extends GradientDescent {
    private final int batchSize;
    private final boolean discardExtras;
    public static final int $stable = 8;

    public StochasticGradientDescent(int batchSize, @NotNull LearningRateSchedule learningRate, @NotNull Random entropy, boolean discardExtras) {
        Intrinsics.checkNotNullParameter((Object)learningRate, (String)"learningRate");
        Intrinsics.checkNotNullParameter((Object)entropy, (String)"entropy");
        super(learningRate, entropy);
        this.batchSize = batchSize;
        this.discardExtras = discardExtras;
        if (!(this.batchSize > 0)) {
            boolean bl = false;
            String string2 = "Batch size must be greater than 0.";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    public /* synthetic */ StochasticGradientDescent(int n, LearningRateSchedule learningRateSchedule, Random random, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            random = (Random)Random.Default;
        }
        if ((n2 & 8) != 0) {
            bl = false;
        }
        this(n, learningRateSchedule, random, bl);
    }

    public final int getBatchSize() {
        return this.batchSize;
    }

    public final boolean getDiscardExtras() {
        return this.discardExtras;
    }

    @Override
    @NotNull
    public List<List<Exercise>> batch(@NotNull List<Exercise> cases) {
        Intrinsics.checkNotNullParameter(cases, (String)"cases");
        List remaining = CollectionsKt.toMutableList((Collection)cases);
        List batches = new ArrayList();
        while (!((Collection)remaining).isEmpty() && (!this.discardExtras || remaining.size() >= this.batchSize)) {
            int n = this.batchSize;
            int n2 = remaining.size();
            int batchSize = Math.min(n, n2);
            List list = batches;
            ArrayList<Exercise> arrayList = new ArrayList<Exercise>(batchSize);
            n2 = 0;
            while (n2 < batchSize) {
                int n3;
                int n4 = n3 = n2++;
                ArrayList<Exercise> arrayList2 = arrayList;
                boolean bl = false;
                arrayList2.add((Exercise)remaining.remove(this.getEntropy().nextInt(remaining.size())));
            }
            list.add((List)arrayList);
        }
        return CollectionsKt.toList((Iterable)batches);
    }
}

