/*
 * Decompiled with CFR 0.152.
 */
package org.polygamma.platform;

import java.util.Locale;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.polygamma.platform.IntegerModel;

public enum Architecture {
    X86(4),
    X86_64(8),
    ARM(4),
    ARM64(8),
    RISCV64(8),
    PPC64(8),
    S390X(8);

    private final IntegerModel wordModel;

    @SideEffectFree
    public static Architecture of(String name) {
        Architecture arch;
        String origName = name;
        if ((name = name.toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "")).matches("^x86(32)?|i[3-6]86|ia32$")) {
            arch = X86;
        } else if (name.matches("^(x(86)?|amd)64|ia32e|em64t|x32$")) {
            arch = X86_64;
        } else if (name.matches("^(aarch|arm)(32)?(v7)?[a-z]*$")) {
            arch = ARM;
        } else if (name.matches("^(aarch|arm)64[a-z]*$")) {
            arch = ARM64;
        } else if (name.matches("^riscv64[a-z]*$")) {
            arch = RISCV64;
        } else if (name.matches("^(powerpc|ppc)64[a-z]*$")) {
            arch = PPC64;
        } else if (name.matches("^s390x|zarch64$")) {
            arch = S390X;
        } else {
            throw new IllegalArgumentException(String.format("Unknown architecture: %s", origName));
        }
        return arch;
    }

    private Architecture(int wordSizeBytes) {
        this.wordModel = IntegerModel.ofBytes(wordSizeBytes);
    }

    @Pure
    public IntegerModel wordModel() {
        return this.wordModel;
    }

    @Pure
    public boolean is64Bit() {
        return this.wordModel.is64Bit();
    }
}

