/*
 * Decompiled with CFR 0.152.
 */
package org.polygamma.platform;

import org.checkerframework.dataflow.qual.Pure;
import org.polygamma.platform.IntegerModel;

public enum DataModel {
    ILP32(4, 4, 4, 4),
    ILP64(8, 8, 8, 8),
    LLP64(4, 4, 8, 8),
    LP64(4, 8, 8, 8);

    private final IntegerModel intModel;
    private final IntegerModel longModel;
    private final IntegerModel llongModel;
    private final IntegerModel pointerModel;

    private DataModel(int intSizeBytes, int longSizeBytes, int llongSizeBytes, int pointerSizeBytes) {
        this.intModel = IntegerModel.ofBytes(intSizeBytes);
        this.longModel = IntegerModel.ofBytes(longSizeBytes);
        this.llongModel = IntegerModel.ofBytes(llongSizeBytes);
        this.pointerModel = IntegerModel.ofBytes(pointerSizeBytes);
    }

    @Pure
    public IntegerModel intModel() {
        return this.intModel;
    }

    @Pure
    public IntegerModel longModel() {
        return this.longModel;
    }

    @Pure
    public IntegerModel llongModel() {
        return this.llongModel;
    }

    @Pure
    public IntegerModel pointerModel() {
        return this.pointerModel;
    }
}

