/*
 * Decompiled with CFR 0.152.
 */
package org.polygamma.platform;

import org.checkerframework.common.reflection.qual.ClassVal;
import org.checkerframework.common.value.qual.IntVal;
import org.checkerframework.dataflow.qual.Pure;

public final class IntegerModel
extends Enum<IntegerModel> {
    public static final /* enum */ IntegerModel BIT32 = new IntegerModel(4);
    public static final /* enum */ IntegerModel BIT64 = new IntegerModel(8);
    private final @IntVal(value={4L, 8L}) int bytes;
    private static final /* synthetic */ IntegerModel[] $VALUES;

    public static IntegerModel[] values() {
        return (IntegerModel[])$VALUES.clone();
    }

    public static IntegerModel valueOf(String name) {
        return Enum.valueOf(IntegerModel.class, name);
    }

    @Pure
    public static IntegerModel ofBytes(int bytes) {
        return switch (bytes) {
            case 8 -> BIT64;
            case 4 -> BIT32;
            default -> throw new IllegalArgumentException("Invalid integer size");
        };
    }

    @Pure
    public static IntegerModel ofBits(int bits) {
        return IntegerModel.ofBytes(bits >> 3);
    }

    private IntegerModel(int bytes) {
        assert (bytes == 4 || bytes == 8) : "@AssumeAssertion(value)";
        this.bytes = bytes;
    }

    @Pure
    public @IntVal(value={4L, 8L}) int bytes() {
        return this.bytes;
    }

    @Pure
    public @IntVal(value={32L, 64L}) int bits() {
        return this.bytes << 3;
    }

    @Pure
    public boolean is64Bit() {
        return this.bytes == 8;
    }

    @Pure
    public boolean is32Bit() {
        return !this.is64Bit();
    }

    @Pure
    public @ClassVal(value={"int", "long"}) Class<?> toJavaType() {
        return this.is64Bit() ? Long.TYPE : Integer.TYPE;
    }

    private static /* synthetic */ IntegerModel[] $values() {
        return new IntegerModel[]{BIT32, BIT64};
    }

    static {
        $VALUES = IntegerModel.$values();
    }
}

