/*
 * Decompiled with CFR 0.152.
 */
package org.polygamma.platform;

import java.util.Locale;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public enum OperatingSystem {
    LINUX,
    FREEBSD,
    NETBSD,
    OPENBSD,
    MACOS,
    WINDOWS;


    @SideEffectFree
    public static OperatingSystem of(String name) {
        OperatingSystem os;
        String origName = name;
        if ((name = name.toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "")).contains("linux")) {
            os = LINUX;
        } else if (name.contains("freebsd")) {
            os = FREEBSD;
        } else if (name.contains("netbsd")) {
            os = NETBSD;
        } else if (name.contains("openbsd")) {
            os = OPENBSD;
        } else if (name.contains("darwin") || name.startsWith("mac") || name.startsWith("osx")) {
            os = MACOS;
        } else if (name.contains("windows")) {
            os = WINDOWS;
        } else {
            throw new IllegalArgumentException(String.format("Unknown operating system: %s", origName));
        }
        return os;
    }

    @Pure
    public boolean isUnix() {
        return this != WINDOWS;
    }

    @Pure
    public String toLibraryPrefix() {
        return this.isUnix() ? "lib" : "";
    }

    @Pure
    public String toLibraryExtension() {
        return this == WINDOWS ? "dll" : (this == MACOS ? "dylib" : "so");
    }

    @Pure
    public String mapLibraryFileName(String libraryName) {
        return String.format("%s%s.%s", this.toLibraryPrefix(), libraryName, this.toLibraryExtension());
    }
}

