/*
 * Decompiled with CFR 0.152.
 */
package org.polygamma.platform;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

public record OperatingSystemVersion(@NonNegative int major, @NonNegative int minor, @NonNegative int patch) implements Comparable<OperatingSystemVersion>
{
    @Pure
    public OperatingSystemVersion(@NonNegative int major, @NonNegative int minor, @NonNegative int patch) {
        if ((major | minor | patch) < 0) {
            throw new IllegalArgumentException(String.format("Malformed version: %d.%d.%d", major, minor, patch));
        }
    }

    @Pure
    public OperatingSystemVersion(int major, int minor) {
        this(major, minor, 0);
    }

    @Pure
    public OperatingSystemVersion(int major) {
        this(major, 0, 0);
    }

    @SideEffectFree
    public static OperatingSystemVersion of(String version) {
        Pattern pattern = Pattern.compile("^([-+_0-9a-z]*-)?(?<version>[0-9]+(\\.[0-9]+)*)(-[-+_0-9a-z]*)?$", 2);
        Matcher matcher = pattern.matcher(version);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Malformed version string: %s", version));
        }
        String normalized = matcher.group("version");
        String[] components = normalized.split("\\.");
        return new OperatingSystemVersion(Integer.parseInt(components[0], 10), components.length > 1 ? Integer.parseInt(components[1], 10) : 0, components.length > 2 ? Integer.parseInt(components[2], 10) : 0);
    }

    @Override
    @Pure
    public int compareTo(OperatingSystemVersion that) {
        int res = Integer.compare(this.major, that.major);
        if (res == 0 && (res = Integer.compare(this.minor, that.minor)) == 0) {
            res = Integer.compare(this.patch, that.patch);
        }
        return res;
    }
}

