/*
 * Decompiled with CFR 0.152.
 */
package org.polygamma.platform;

import java.util.Objects;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.polygamma.platform.Architecture;
import org.polygamma.platform.DataModel;
import org.polygamma.platform.OperatingSystem;
import org.polygamma.platform.OperatingSystemVersion;

public record Platform(OperatingSystem os, @Nullable OperatingSystemVersion osVersion, Architecture architecture, DataModel dataModel) {
    private static final Object CURRENT;

    @Pure
    public Platform(OperatingSystem os, @Nullable OperatingSystemVersion osVersion, Architecture architecture, DataModel dataModel) {
        Objects.requireNonNull(os);
        Objects.requireNonNull(architecture);
        Objects.requireNonNull(dataModel);
    }

    @Pure
    public Platform(OperatingSystem os, Architecture architecture, DataModel dataModel) {
        this(os, null, architecture, dataModel);
    }

    @Pure
    public Platform(OperatingSystem os, @Nullable OperatingSystemVersion osVersion, Architecture architecture) {
        this(os, osVersion, architecture, architecture.is64Bit() ? (os.isUnix() ? DataModel.LP64 : DataModel.LLP64) : DataModel.ILP32);
    }

    @Pure
    public Platform(OperatingSystem os, Architecture architecture) {
        this(os, null, architecture);
    }

    @Pure
    public static Platform current() {
        Object object = CURRENT;
        if (object instanceof Platform) {
            Platform current = (Platform)object;
            return current;
        }
        throw new UnsupportedOperationException((Throwable)CURRENT);
    }

    @Pure
    public boolean isOs(OperatingSystem that) {
        return this.os == that;
    }

    @Pure
    public int compareOsVersion(OperatingSystemVersion that) {
        return this.osVersion == null ? -1 : this.osVersion.compareTo(that);
    }

    @Pure
    public int compareOsVersion(int major, int minor, int patch) {
        return this.compareOsVersion(new OperatingSystemVersion(major, minor, patch));
    }

    @Pure
    public int compareOsVersion(int major, int minor) {
        return this.compareOsVersion(major, minor, 0);
    }

    @Pure
    public int compareOsVersion(int major) {
        return this.compareOsVersion(major, 0, 0);
    }

    @Pure
    public boolean isArchitecture(Architecture that) {
        return this.architecture == that;
    }

    @Pure
    public boolean isDataModel(DataModel that) {
        return this.dataModel == that;
    }

    @Pure
    public boolean is64BitWord() {
        return this.architecture.is64Bit();
    }

    @Pure
    public boolean is64BitAddress() {
        return this.dataModel.pointerModel().is64Bit();
    }

    static {
        Object current;
        Function<String, String> property = name -> {
            @Nullable String value = System.getProperty(name);
            if (value == null) {
                throw new IllegalStateException(String.format("System property %s not defined", name));
            }
            return value;
        };
        try {
            OperatingSystem os = OperatingSystem.of(property.apply("os.name"));
            OperatingSystemVersion osv = OperatingSystemVersion.of(property.apply("os.version"));
            String archName = property.apply("os.arch");
            Architecture arch = Architecture.of(archName);
            DataModel dataModel = "x32".equals(archName) || !arch.is64Bit() ? DataModel.ILP32 : (os == OperatingSystem.WINDOWS ? DataModel.LLP64 : DataModel.LP64);
            current = new Platform(os, osv, arch, dataModel);
        }
        catch (Throwable e) {
            current = new IllegalStateException("Failed to probe current platform", e);
        }
        CURRENT = current;
    }
}

