/*
 * Decompiled with CFR 0.152.
 */
package org.polyglotted.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.polyglotted.crypto.asymmetric.RsaDecrypter;
import org.polyglotted.crypto.asymmetric.RsaEncrypter;
import org.polyglotted.crypto.symmetric.AesDecrypter;
import org.polyglotted.crypto.symmetric.AesEncrypter;

enum Algo {
    RsaEncrypt{

        @Override
        String cryptText(File file, String string, String string2) throws IOException {
            return RsaEncrypter.encrypt(new FileInputStream(file), string2);
        }

        @Override
        void cryptFile(File file, String string, InputStream inputStream, OutputStream outputStream) throws IOException {
            RsaEncrypter.encryptFile(new FileInputStream(file), inputStream, outputStream);
        }

        @Override
        void cryptPropertyFile(File file, String string, InputStream inputStream, OutputStream outputStream, String string2) throws IOException {
            RsaEncrypter.encryptPropertyFile(new FileInputStream(file), inputStream, outputStream, string2);
        }
    }
    ,
    RsaDecrypt{

        @Override
        String cryptText(File file, String string, String string2) throws IOException {
            return RsaDecrypter.decrypt(new FileInputStream(file), string2);
        }

        @Override
        void cryptFile(File file, String string, InputStream inputStream, OutputStream outputStream) throws IOException {
            RsaDecrypter.decryptFile(new FileInputStream(file), inputStream, outputStream);
        }

        @Override
        void cryptPropertyFile(File file, String string, InputStream inputStream, OutputStream outputStream, String string2) throws IOException {
            RsaDecrypter.decryptPropertyFile(new FileInputStream(file), inputStream, outputStream, string2);
        }
    }
    ,
    AesEncrypt{

        @Override
        String cryptText(File file, String string, String string2) throws IOException {
            return AesEncrypter.encrypt(string, string2);
        }

        @Override
        void cryptFile(File file, String string, InputStream inputStream, OutputStream outputStream) throws IOException {
            throw new UnsupportedOperationException("AES not supported for encrypting simple files");
        }

        @Override
        void cryptPropertyFile(File file, String string, InputStream inputStream, OutputStream outputStream, String string2) throws IOException {
            AesEncrypter.encryptPropertyFile(string, inputStream, outputStream, string2);
        }
    }
    ,
    AesDecrypt{

        @Override
        String cryptText(File file, String string, String string2) throws IOException {
            return AesDecrypter.decrypt(string, string2);
        }

        @Override
        void cryptFile(File file, String string, InputStream inputStream, OutputStream outputStream) throws IOException {
            throw new UnsupportedOperationException("AES not supported for decrypting simple files");
        }

        @Override
        void cryptPropertyFile(File file, String string, InputStream inputStream, OutputStream outputStream, String string2) throws IOException {
            AesDecrypter.decryptPropertyFile(string, inputStream, outputStream, string2);
        }
    };


    abstract String cryptText(File var1, String var2, String var3) throws IOException;

    abstract void cryptFile(File var1, String var2, InputStream var3, OutputStream var4) throws IOException;

    abstract void cryptPropertyFile(File var1, String var2, InputStream var3, OutputStream var4, String var5) throws IOException;
}

