/*
 * Decompiled with CFR 0.152.
 */
package org.polyglotted.crypto.api;

import java.io.PrintWriter;
import javax.crypto.Cipher;
import org.polyglotted.crypto.api.Crypto;
import org.polyglotted.crypto.utils.Charsets;

public abstract class AbstractCrypto
implements Crypto {
    protected final Cipher cipher;

    public AbstractCrypto(Cipher cipher) {
        this.cipher = cipher;
    }

    @Override
    public Cipher getCipher() {
        return this.cipher;
    }

    @Override
    public String getAlgorithm() {
        return this.cipher.getAlgorithm();
    }

    public boolean handlePropertyFirstLine(String string, PrintWriter printWriter) {
        if (this.getMode() == Mode.ENCRYPT) {
            printWriter.println(this.getHeaderLine());
            return false;
        }
        return true;
    }

    protected String getHeaderLine() {
        return "#" + this.getAlgorithm();
    }

    protected byte[] encrypt(String string) {
        return this.cipher.doFinal(Charsets.UTF8.getBytes(string));
    }

    @Override
    public final byte[] crypt(byte[] byArray) {
        return this.cipher.doFinal(byArray);
    }

    public abstract Mode getMode();

    public static enum Mode {
        ENCRYPT,
        DECRYPT;

    }
}

