/*
 * Decompiled with CFR 0.152.
 */
package org.polyglotted.crypto.symmetric;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import org.polyglotted.crypto.api.AbstractCrypto;
import org.polyglotted.crypto.symmetric.Aes;
import org.polyglotted.crypto.utils.Charsets;
import org.polyglotted.crypto.utils.FileCryptoUtils;
import org.polyglotted.crypto.utils.HexUtils;

public class AesDecrypter
extends AbstractCrypto {
    private final String passPhrase;
    private boolean initialised = false;

    public AesDecrypter(String string) {
        super(AesDecrypter.createCipher());
        this.passPhrase = string;
    }

    public AesDecrypter(String string, byte[] byArray) {
        this(string);
        this.initialiseCipher(byArray);
    }

    private static Cipher createCipher() {
        return Cipher.getInstance("AES/CBC/PKCS5Padding");
    }

    private void initialiseCipher(byte[] byArray) {
        this.cipher.init(2, (Key)Aes.createSecret(this.passPhrase), new IvParameterSpec(byArray));
        this.initialised = true;
    }

    @Override
    public AbstractCrypto.Mode getMode() {
        return AbstractCrypto.Mode.DECRYPT;
    }

    @Override
    public String crypt(String string) {
        int n = string.indexOf(36);
        if (n > 0) {
            if (!this.initialised) {
                byte[] byArray = HexUtils.decode(string.substring(0, n));
                this.initialiseCipher(byArray);
            }
            string = string.substring(n + 1);
        }
        return Charsets.UTF8.getString(this.crypt(HexUtils.decode(string)));
    }

    public static String decrypt(String string, String string2) {
        AesDecrypter aesDecrypter = new AesDecrypter(string);
        return aesDecrypter.crypt(string2);
    }

    public static void decryptPropertyFile(String string, InputStream inputStream, OutputStream outputStream, String string2) {
        AesDecrypter aesDecrypter = new AesDecrypter(string);
        FileCryptoUtils.cryptCopy(aesDecrypter, inputStream, outputStream, string2);
    }
}

