/*
 * Decompiled with CFR 0.152.
 */
package org.polyglotted.crypto.utils;

public abstract class HexUtils {
    private static final byte[] decodingTable;
    private static final byte[] encodingTable;

    public static String encodeString(byte[] byArray) {
        return new String(HexUtils.encode(byArray));
    }

    public static byte[] encode(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length * 2];
        for (int i = 0; i < byArray.length; ++i) {
            HexUtils.encode(byArray[i], byArray2, i * 2);
        }
        return byArray2;
    }

    public static void encode(byte by, byte[] byArray, int n) {
        int n2 = by & 0xFF;
        byArray[n] = encodingTable[n2 >>> 4];
        byArray[n + 1] = encodingTable[n2 & 0xF];
    }

    public static byte[] decode(String string) {
        return HexUtils.decode(string.getBytes());
    }

    public static byte[] decode(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length / 2];
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            byArray2[n2] = HexUtils.decode(byArray[n], byArray[n + 1]);
            n += 2;
            ++n2;
        }
        return byArray2;
    }

    public static byte decode(byte by, byte by2) {
        return (byte)(decodingTable[by] << 4 | decodingTable[by2]);
    }

    static {
        int n;
        decodingTable = new byte[128];
        encodingTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
        for (n = 0; n < encodingTable.length; ++n) {
            HexUtils.decodingTable[HexUtils.encodingTable[n]] = (byte)n;
        }
        n = 65;
        int n2 = 97;
        while (n <= 70) {
            HexUtils.decodingTable[n] = decodingTable[n2];
            ++n;
            ++n2;
        }
    }
}

