/*
 * Decompiled with CFR 0.152.
 */
package org.polyglotted.crypto.asymmetric;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import net.iharder.Base64;
import org.polyglotted.crypto.api.AbstractCrypto;
import org.polyglotted.crypto.asymmetric.RsaKeyReader;
import org.polyglotted.crypto.utils.Charsets;
import org.polyglotted.crypto.utils.FileCryptoUtils;
import org.polyglotted.crypto.utils.IoUtils;

public class RsaDecrypter
extends AbstractCrypto {
    public RsaDecrypter(PrivateKey privateKey) {
        super(RsaDecrypter.createCipher(privateKey));
    }

    private static Cipher createCipher(PrivateKey privateKey) {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, privateKey);
        return cipher;
    }

    @Override
    public AbstractCrypto.Mode getMode() {
        return AbstractCrypto.Mode.DECRYPT;
    }

    @Override
    public String crypt(String string) {
        return Charsets.UTF8.getString(this.crypt(Base64.decode(string)));
    }

    public static String decrypt(InputStream inputStream, String string) {
        RsaDecrypter rsaDecrypter = new RsaDecrypter(RsaKeyReader.readPrivateKey(inputStream));
        return rsaDecrypter.crypt(string);
    }

    public static void decryptFile(InputStream inputStream, InputStream inputStream2, OutputStream outputStream) {
        RsaDecrypter rsaDecrypter = new RsaDecrypter(RsaKeyReader.readPrivateKey(inputStream));
        IoUtils.copy(new CipherInputStream(inputStream2, rsaDecrypter.getCipher()), outputStream);
    }

    public static void decryptPropertyFile(InputStream inputStream, InputStream inputStream2, OutputStream outputStream, String string) {
        RsaDecrypter rsaDecrypter = new RsaDecrypter(RsaKeyReader.readPrivateKey(inputStream));
        FileCryptoUtils.cryptCopy(rsaDecrypter, inputStream2, outputStream, string);
    }
}

