/*
 * Decompiled with CFR 0.152.
 */
package org.polyglotted.crypto.asymmetric;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.PublicKey;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import net.iharder.Base64;
import org.polyglotted.crypto.api.AbstractCrypto;
import org.polyglotted.crypto.asymmetric.RsaKeyReader;
import org.polyglotted.crypto.utils.FileCryptoUtils;
import org.polyglotted.crypto.utils.IoUtils;

public class RsaEncrypter
extends AbstractCrypto {
    private int base64Options = 0;

    public RsaEncrypter(PublicKey publicKey) {
        super(RsaEncrypter.createCipher(publicKey));
    }

    private static Cipher createCipher(PublicKey publicKey) {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, publicKey);
        return cipher;
    }

    @Override
    public AbstractCrypto.Mode getMode() {
        return AbstractCrypto.Mode.ENCRYPT;
    }

    @Override
    public String crypt(String string) {
        return Base64.encodeBytes(this.encrypt(string), this.base64Options);
    }

    public void setBase64Options(int n) {
        this.base64Options = n;
    }

    public static String encrypt(InputStream inputStream, String string) {
        RsaEncrypter rsaEncrypter = new RsaEncrypter(RsaKeyReader.readPublicKey(inputStream));
        rsaEncrypter.setBase64Options(8);
        return rsaEncrypter.crypt(string);
    }

    public static void encryptFile(InputStream inputStream, InputStream inputStream2, OutputStream outputStream) {
        RsaEncrypter rsaEncrypter = new RsaEncrypter(RsaKeyReader.readPublicKey(inputStream));
        IoUtils.copy(inputStream2, new CipherOutputStream(outputStream, rsaEncrypter.getCipher()));
    }

    public static void encryptPropertyFile(InputStream inputStream, InputStream inputStream2, OutputStream outputStream, String string) {
        RsaEncrypter rsaEncrypter = new RsaEncrypter(RsaKeyReader.readPublicKey(inputStream));
        FileCryptoUtils.cryptCopy(rsaEncrypter, inputStream2, outputStream, string);
    }
}

