/*
 * Decompiled with CFR 0.152.
 */
package org.polyglotted.crypto.asymmetric;

import java.io.InputStream;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import net.iharder.Base64;
import org.polyglotted.crypto.utils.IoUtils;

public abstract class RsaKeyReader {
    public static PrivateKey readPrivateKey(InputStream inputStream) {
        byte[] byArray = Base64.decode(IoUtils.readBytes(inputStream));
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
    }

    public static PublicKey readPublicKey(InputStream inputStream) {
        byte[] byArray = Base64.decode(IoUtils.readBytes(inputStream));
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(x509EncodedKeySpec);
    }
}

