/*
 * Decompiled with CFR 0.152.
 */
package org.polyglotted.crypto.digest;

import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import org.polyglotted.crypto.utils.Charsets;
import org.polyglotted.crypto.utils.HexUtils;
import org.polyglotted.crypto.utils.IoUtils;

public abstract class AbstractDigest {
    private static final byte[] SALT = HexUtils.decode("ba29f91d6158c26d");
    private final MessageDigest digest;

    protected AbstractDigest(MessageDigest messageDigest) {
        this.digest = messageDigest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String create(InputStream inputStream) {
        this.digest.reset();
        DigestInputStream digestInputStream = new DigestInputStream(inputStream, this.digest);
        byte[] byArray = new byte[8192];
        try {
            while (digestInputStream.read(byArray) != -1) {
            }
        }
        finally {
            IoUtils.safeClose(digestInputStream);
        }
        this.digest.update(SALT);
        return HexUtils.encodeString(this.digest.digest());
    }

    public String create(String string) {
        return this.create(Charsets.UTF8.getBytes(string));
    }

    public String create(byte[] byArray) {
        this.digest.reset();
        this.digest.update(byArray);
        this.digest.update(SALT);
        return HexUtils.encodeString(this.digest.digest());
    }
}

