/*
 * Decompiled with CFR 0.152.
 */
package org.polyglotted.crypto.digest;

import java.io.InputStream;
import java.util.zip.CRC32;
import org.polyglotted.crypto.utils.Charsets;

public abstract class Crc32Checksum {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String create(InputStream inputStream) {
        CRC32 cRC32 = new CRC32();
        try {
            int n;
            byte[] byArray = new byte[8192];
            do {
                if ((n = inputStream.read(byArray)) <= 0) continue;
                cRC32.update(byArray, 0, n);
            } while (n != -1);
        }
        finally {
            inputStream.close();
        }
        return Long.toHexString(cRC32.getValue());
    }

    public static String create(String string) {
        return Crc32Checksum.create(Charsets.UTF8.getBytes(string));
    }

    public static String create(byte[] byArray) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        return Long.toHexString(cRC32.getValue());
    }
}

