/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.evaluator.entry;

import java.io.Serializable;
import lombok.Generated;
import org.powerflows.dmn.engine.evaluator.context.EvaluationContext;
import org.powerflows.dmn.engine.evaluator.entry.mode.provider.EvaluationModeProvider;
import org.powerflows.dmn.engine.evaluator.entry.mode.provider.EvaluationModeProviderFactory;
import org.powerflows.dmn.engine.evaluator.expression.provider.DefaultExpressionEvaluationProviderFactory;
import org.powerflows.dmn.engine.evaluator.expression.provider.ExpressionEvaluationProvider;
import org.powerflows.dmn.engine.evaluator.type.converter.TypeConverter;
import org.powerflows.dmn.engine.evaluator.type.converter.TypeConverterFactory;
import org.powerflows.dmn.engine.evaluator.type.value.SpecifiedTypeValue;
import org.powerflows.dmn.engine.model.decision.EvaluationMode;
import org.powerflows.dmn.engine.model.decision.field.Input;
import org.powerflows.dmn.engine.model.decision.field.ValueType;
import org.powerflows.dmn.engine.model.decision.rule.entry.InputEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputEntryEvaluator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InputEntryEvaluator.class);
    private final DefaultExpressionEvaluationProviderFactory expressionEvaluationProviderFactory;
    private final TypeConverterFactory typeConverterFactory;
    private final EvaluationModeProviderFactory evaluationModeProviderFactory;

    public InputEntryEvaluator(DefaultExpressionEvaluationProviderFactory expressionEvaluationProviderFactory, TypeConverterFactory typeConverterFactory, EvaluationModeProviderFactory evaluationModeProviderFactory) {
        this.expressionEvaluationProviderFactory = expressionEvaluationProviderFactory;
        this.typeConverterFactory = typeConverterFactory;
        this.evaluationModeProviderFactory = evaluationModeProviderFactory;
    }

    public boolean evaluate(InputEntry inputEntry, Input input, EvaluationContext evaluationContext) {
        SpecifiedTypeValue typedInputEntryValue;
        log.debug("Starting evaluation of input entry: {} with input: {} and evaluation context: {}", new Object[]{inputEntry, input, evaluationContext});
        ExpressionEvaluationProvider inputEntryExpressionEvaluator = this.expressionEvaluationProviderFactory.getInstance(inputEntry.getExpression().getType());
        TypeConverter typeConverter = this.typeConverterFactory.getInstance(input.getType());
        if (!this.isInputEvaluated(input, evaluationContext)) {
            ExpressionEvaluationProvider inputExpressionEvaluator = this.expressionEvaluationProviderFactory.getInstance(input.getExpression().getType());
            Serializable evaluatedInputValue = inputExpressionEvaluator.evaluateInput(input, evaluationContext);
            evaluationContext.addVariable(input.getName(), evaluatedInputValue);
        }
        Serializable inputValue = evaluationContext.get(inputEntry.getName());
        SpecifiedTypeValue typedInputValue = typeConverter.convert((Object)inputValue);
        Serializable inputEntryValue = inputEntryExpressionEvaluator.evaluateInputEntry(inputEntry, evaluationContext);
        if (this.isBoolean(inputEntryValue)) {
            TypeConverter booleanTypeConverter = ValueType.BOOLEAN == input.getType() ? typeConverter : this.typeConverterFactory.getInstance(ValueType.BOOLEAN);
            typedInputEntryValue = booleanTypeConverter.convert((Object)inputEntryValue);
        } else {
            typedInputEntryValue = typeConverter.convert((Object)inputEntryValue);
        }
        EvaluationMode evaluationMode = inputEntry.getEvaluationMode();
        EvaluationModeProvider evaluationModeProvider = this.evaluationModeProviderFactory.getInstance(evaluationMode);
        boolean result = evaluationModeProvider.isPositive(input.getType(), typedInputEntryValue, typedInputValue);
        log.debug("Evaluated input entry result: {}", (Object)result);
        return result;
    }

    private boolean isBoolean(Object value) {
        return Boolean.TRUE.equals(value) || Boolean.FALSE.equals(value);
    }

    private boolean isInputEvaluated(Input input, EvaluationContext evaluationContext) {
        return evaluationContext.isPresent(input.getName());
    }
}

