/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.evaluator.entry.mode.provider;

import java.util.EnumMap;
import org.powerflows.dmn.engine.evaluator.entry.mode.provider.BooleanEvaluationModeProvider;
import org.powerflows.dmn.engine.evaluator.entry.mode.provider.EvaluationModeProvider;
import org.powerflows.dmn.engine.evaluator.entry.mode.provider.InputComparisonEvaluationModeProvider;
import org.powerflows.dmn.engine.model.decision.EvaluationMode;

public class EvaluationModeProviderFactory {
    private final EnumMap<EvaluationMode, EvaluationModeProvider> factories = new EnumMap(EvaluationMode.class);

    public EvaluationModeProviderFactory() {
        this.factories.put(EvaluationMode.BOOLEAN, new BooleanEvaluationModeProvider());
        this.factories.put(EvaluationMode.INPUT_COMPARISON, new InputComparisonEvaluationModeProvider());
    }

    public EvaluationModeProvider getInstance(EvaluationMode evaluationMode) {
        EvaluationModeProvider evaluationModeProvider = this.factories.get(evaluationMode);
        if (evaluationModeProvider == null) {
            throw new IllegalArgumentException("Unknown evaluation mode " + evaluationMode);
        }
        return evaluationModeProvider;
    }
}

