/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.evaluator.entry;

import java.io.Serializable;
import lombok.Generated;
import org.powerflows.dmn.engine.evaluator.context.EvaluationContext;
import org.powerflows.dmn.engine.evaluator.expression.provider.DefaultExpressionEvaluationProviderFactory;
import org.powerflows.dmn.engine.evaluator.expression.provider.ExpressionEvaluationProvider;
import org.powerflows.dmn.engine.evaluator.type.converter.TypeConverter;
import org.powerflows.dmn.engine.evaluator.type.converter.TypeConverterFactory;
import org.powerflows.dmn.engine.model.decision.field.Output;
import org.powerflows.dmn.engine.model.decision.rule.entry.OutputEntry;
import org.powerflows.dmn.engine.model.evaluation.result.EntryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputEntryEvaluator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OutputEntryEvaluator.class);
    private final DefaultExpressionEvaluationProviderFactory expressionEvaluationProviderFactory;
    private final TypeConverterFactory typeConverterFactory;

    public OutputEntryEvaluator(DefaultExpressionEvaluationProviderFactory expressionEvaluationProviderFactory, TypeConverterFactory typeConverterFactory) {
        this.expressionEvaluationProviderFactory = expressionEvaluationProviderFactory;
        this.typeConverterFactory = typeConverterFactory;
    }

    public EntryResult evaluate(OutputEntry outputEntry, Output output, EvaluationContext evaluationContext) {
        ExpressionEvaluationProvider expressionEvaluator = this.expressionEvaluationProviderFactory.getInstance(outputEntry.getExpression().getType());
        TypeConverter typeConverter = this.typeConverterFactory.getInstance(output.getType());
        Serializable outputEntryValue = expressionEvaluator.evaluateOutputEntry(outputEntry, evaluationContext);
        typeConverter.convert((Object)outputEntryValue);
        EntryResult outputEntryResult = (EntryResult)EntryResult.builder().name(outputEntry.getName()).value(outputEntryValue).build();
        log.debug("Evaluated output entry result: {}", (Object)outputEntryResult);
        return outputEntryResult;
    }
}

