/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.evaluator.expression.provider;

import java.io.Serializable;
import java.util.Map;
import java.util.stream.Collectors;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import lombok.Generated;
import org.powerflows.dmn.engine.evaluator.context.EvaluationContext;
import org.powerflows.dmn.engine.evaluator.exception.EvaluationException;
import org.powerflows.dmn.engine.evaluator.expression.provider.ExpressionEvaluationConfiguration;
import org.powerflows.dmn.engine.evaluator.expression.provider.ExpressionEvaluationProvider;
import org.powerflows.dmn.engine.evaluator.expression.provider.binding.MethodBinding;
import org.powerflows.dmn.engine.evaluator.expression.script.bindings.ContextVariablesBindings;
import org.powerflows.dmn.engine.model.decision.expression.Expression;
import org.powerflows.dmn.engine.model.decision.field.Input;
import org.powerflows.dmn.engine.model.decision.rule.entry.InputEntry;
import org.powerflows.dmn.engine.model.decision.rule.entry.OutputEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScriptEngineExpressionEvaluationProvider
implements ExpressionEvaluationProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScriptEngineExpressionEvaluationProvider.class);
    protected final ScriptEngine scriptEngine;

    public ScriptEngineExpressionEvaluationProvider(ExpressionEvaluationConfiguration configuration) {
        this.scriptEngine = configuration.getScriptEngineManager().getEngineByName(this.getEngineName());
        if (this.scriptEngine == null) {
            throw new IllegalStateException("Unsupported script engine: " + this.getEngineName());
        }
        Bindings bindings = this.scriptEngine.createBindings();
        bindings.putAll((Map<? extends String, ? extends Object>)configuration.getMethodBindings().stream().collect(Collectors.toMap(MethodBinding::name, this::createMethodBinding)));
        this.scriptEngine.setBindings(bindings, 200);
    }

    protected abstract Object createMethodBinding(MethodBinding var1);

    protected abstract String getEngineName();

    @Override
    public Serializable evaluateInput(Input input, EvaluationContext evaluationContext) {
        log.debug("Starting evaluation of input: {} with evaluation context: {}", (Object)input, (Object)evaluationContext);
        Serializable result = this.evaluate(input.getExpression(), evaluationContext);
        log.debug("Evaluated result: {}", (Object)result);
        return result;
    }

    @Override
    public Serializable evaluateInputEntry(InputEntry inputEntry, EvaluationContext evaluationContext) {
        log.debug("Starting evaluation of input entry {} with evaluation context: {}", (Object)inputEntry, (Object)evaluationContext);
        Serializable result = this.evaluate(inputEntry, evaluationContext);
        log.debug("Evaluated entry result: {}", (Object)result);
        return result;
    }

    @Override
    public Serializable evaluateOutputEntry(OutputEntry outputEntry, EvaluationContext evaluationContext) {
        log.debug("Starting evaluation of output entry {} with evaluation context: {}", (Object)outputEntry, (Object)evaluationContext);
        Serializable result = this.evaluate(outputEntry.getExpression(), evaluationContext);
        log.debug("Evaluated entry result: {}", (Object)result);
        return result;
    }

    private Serializable evaluate(InputEntry inputEntry, EvaluationContext evaluationContext) {
        ContextVariablesBindings bindings = ContextVariablesBindings.create(this.scriptEngine.createBindings(), evaluationContext, inputEntry);
        return this.evaluate(inputEntry.getExpression(), this.scriptEngine, bindings);
    }

    private Serializable evaluate(Expression expression, EvaluationContext evaluationContext) {
        ContextVariablesBindings bindings = ContextVariablesBindings.create(this.scriptEngine.createBindings(), evaluationContext);
        return this.evaluate(expression, this.scriptEngine, bindings);
    }

    private Serializable evaluate(Expression expression, ScriptEngine scriptEngine, Bindings bindings) {
        Serializable result;
        try {
            result = (Serializable)scriptEngine.eval((String)((Object)expression.getValue()), bindings);
        }
        catch (ScriptException e) {
            throw new EvaluationException("Script evaluation exception", e);
        }
        return result;
    }
}

