/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.evaluator.expression.provider.binding;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import org.powerflows.dmn.engine.evaluator.expression.ExpressionEvaluationException;
import org.powerflows.dmn.engine.evaluator.expression.provider.binding.MethodBinding;

public abstract class AbstractMethodBinding
implements MethodBinding {
    private final String name;
    private final Supplier<Object> instanceSupplier;
    private final Method method;

    public AbstractMethodBinding(String name, Method method, Supplier<Object> instanceSupplier) {
        this.name = name;
        this.instanceSupplier = instanceSupplier;
        this.method = method;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Method method() {
        return this.method;
    }

    @Override
    public Object execute(Object ... args) {
        try {
            return this.method.invoke(this.instanceSupplier.get(), args);
        }
        catch (IllegalAccessException | IllegalArgumentException | NullPointerException | InvocationTargetException e) {
            throw new ExpressionEvaluationException(e);
        }
    }
}

