/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.evaluator.type.converter;

import java.util.List;
import org.powerflows.dmn.engine.evaluator.exception.EvaluationException;
import org.powerflows.dmn.engine.evaluator.type.converter.BaseTypeConverter;
import org.powerflows.dmn.engine.evaluator.type.value.BooleanValue;
import org.powerflows.dmn.engine.evaluator.type.value.SpecifiedTypeValue;

public class BooleanConverter
extends BaseTypeConverter<Boolean> {
    @Override
    protected SpecifiedTypeValue<Boolean> createValue(Boolean value) {
        return new BooleanValue(value);
    }

    @Override
    protected SpecifiedTypeValue<Boolean> createValue(List<Boolean> values) {
        return new BooleanValue(values);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Boolean convertSingleObject(Object unspecifiedValue) {
        boolean booleanValue;
        if (unspecifiedValue instanceof Boolean) {
            booleanValue = (Boolean)unspecifiedValue;
            return booleanValue;
        } else {
            if (!(unspecifiedValue instanceof String)) throw new EvaluationException("Value " + unspecifiedValue + " is not boolean");
            if ("true".equalsIgnoreCase((String)unspecifiedValue)) {
                booleanValue = true;
                return booleanValue;
            } else {
                if (!"false".equalsIgnoreCase((String)unspecifiedValue)) throw new EvaluationException("Value " + unspecifiedValue + " is not boolean");
                booleanValue = false;
            }
        }
        return booleanValue;
    }
}

