/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.evaluator.type.converter;

import java.util.List;
import org.powerflows.dmn.engine.evaluator.exception.EvaluationException;
import org.powerflows.dmn.engine.evaluator.type.converter.BaseTypeConverter;
import org.powerflows.dmn.engine.evaluator.type.value.IntegerValue;
import org.powerflows.dmn.engine.evaluator.type.value.SpecifiedTypeValue;

public class IntegerConverter
extends BaseTypeConverter<Integer> {
    @Override
    protected SpecifiedTypeValue<Integer> createValue(Integer value) {
        return new IntegerValue(value);
    }

    @Override
    protected SpecifiedTypeValue<Integer> createValue(List<Integer> values) {
        return new IntegerValue(values);
    }

    private boolean isInteger(Number value) {
        double doubleValue = value.doubleValue();
        return doubleValue == (double)((int)doubleValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Integer convertSingleObject(Object unspecifiedValue) {
        int intValue;
        if (unspecifiedValue instanceof Number) {
            if (!this.isInteger((Number)unspecifiedValue)) throw new EvaluationException("Value " + unspecifiedValue + " is not integer");
            intValue = ((Number)unspecifiedValue).intValue();
            return intValue;
        }
        if (!(unspecifiedValue instanceof String)) throw new EvaluationException("Value " + unspecifiedValue + " is not integer");
        try {
            intValue = Integer.parseInt((String)unspecifiedValue);
            return intValue;
        }
        catch (NumberFormatException e) {
            throw new EvaluationException("Value " + unspecifiedValue + " is not integer");
        }
    }
}

