/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.evaluator.expression.provider.feel.converter.mvel;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.powerflows.dmn.engine.evaluator.expression.ExpressionEvaluationException;
import org.powerflows.dmn.engine.evaluator.expression.provider.feel.converter.ExpressionConverter;

public class FeelToMvelRangeExpressionConverter
implements ExpressionConverter {
    private final Pattern rangePattern = Pattern.compile("^(\\(|\\]|\\[)(.*[^\\.])\\.\\.(.+)(\\)|\\[|\\])$");
    private final ExpressionConverter feelToMvelFunctionExpressionConverter;

    FeelToMvelRangeExpressionConverter(ExpressionConverter feelToMvelFunctionExpressionConverter) {
        this.feelToMvelFunctionExpressionConverter = feelToMvelFunctionExpressionConverter;
    }

    @Override
    public String convert(String feelExpression, String inputName) {
        if (inputName == null) {
            throw new ExpressionEvaluationException("Can not evaluate feel expression '" + feelExpression + "', due to applicable only for input entry expressions");
        }
        Matcher matcher = this.rangePattern.matcher(feelExpression);
        if (!matcher.matches()) {
            throw new ExpressionEvaluationException("Can not evaluate feel expression '" + feelExpression + "'");
        }
        String startRangeSymbol = matcher.group(1);
        String startRangeOperand = matcher.group(2);
        String endRangeOperand = matcher.group(3);
        String endRangeSymbol = matcher.group(4);
        String mvelStartComparator = this.convertToMvelStartComparator(startRangeSymbol);
        String mvelEndComparator = this.convertToMvelEndComparator(endRangeSymbol);
        if (this.feelToMvelFunctionExpressionConverter.isConvertible(startRangeOperand)) {
            startRangeOperand = this.feelToMvelFunctionExpressionConverter.convert(startRangeOperand, null);
        }
        if (this.feelToMvelFunctionExpressionConverter.isConvertible(endRangeOperand)) {
            endRangeOperand = this.feelToMvelFunctionExpressionConverter.convert(endRangeOperand, null);
        }
        return inputName + mvelStartComparator + startRangeOperand + "&&" + inputName + mvelEndComparator + endRangeOperand;
    }

    @Override
    public boolean isConvertible(String feelExpression) {
        return feelExpression.startsWith("(") || feelExpression.startsWith("[") || feelExpression.startsWith("]");
    }

    private String convertToMvelStartComparator(String startRangeSymbol) {
        return startRangeSymbol.equals("[") ? ">=" : ">";
    }

    private String convertToMvelEndComparator(String endRangeSymbol) {
        return endRangeSymbol.equals("]") ? "<=" : "<";
    }
}

