/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.evaluator.expression.provider;

import java.io.Serializable;
import java.util.Map;
import java.util.WeakHashMap;
import lombok.Generated;
import org.mvel2.integration.VariableResolverFactory;
import org.powerflows.dmn.engine.evaluator.context.EvaluationContext;
import org.powerflows.dmn.engine.evaluator.expression.provider.ExpressionEvaluationConfiguration;
import org.powerflows.dmn.engine.evaluator.expression.provider.MvelExpressionEvaluationProvider;
import org.powerflows.dmn.engine.evaluator.expression.provider.feel.converter.ExpressionConverter;
import org.powerflows.dmn.engine.evaluator.expression.provider.feel.converter.mvel.FeelToMvelExpressionConverter;
import org.powerflows.dmn.engine.model.decision.expression.Expression;
import org.powerflows.dmn.engine.model.decision.field.Input;
import org.powerflows.dmn.engine.model.decision.rule.entry.InputEntry;
import org.powerflows.dmn.engine.model.decision.rule.entry.OutputEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FeelExpressionEvaluationProvider
extends MvelExpressionEvaluationProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FeelExpressionEvaluationProvider.class);
    private final ExpressionConverter expressionConverter;
    private final Map<Key, String> expressionCache = new WeakHashMap<Key, String>();

    FeelExpressionEvaluationProvider(ExpressionEvaluationConfiguration configuration) {
        super(configuration);
        this.expressionConverter = new FeelToMvelExpressionConverter(configuration.getMethodBindings());
    }

    public Serializable evaluateInput(Input input, EvaluationContext evaluationContext) {
        log.debug("Starting evaluation of input: {} with evaluation context: {}", (Object)input, (Object)evaluationContext);
        Key key = Key.builder().expression(String.valueOf(input.getExpression().getValue())).build();
        String mvelInputExpressionValue = this.expressionCache.computeIfAbsent(key, k -> this.expressionConverter.convert(((Key)k).expression, ((Key)k).inputName));
        Expression mvelInputExpression = (Expression)((Expression.Builder)((Expression.Builder)Expression.builder().type(input.getExpression().getType())).value((Serializable)((Object)mvelInputExpressionValue))).build();
        Serializable result = this.evaluate(mvelInputExpression, evaluationContext);
        log.debug("Evaluated result: {}", (Object)result);
        return result;
    }

    public Serializable evaluateOutputEntry(OutputEntry outputEntry, EvaluationContext evaluationContext) {
        log.debug("Starting evaluation of output entry with evaluation context: {}", (Object)outputEntry, (Object)evaluationContext);
        Key key = Key.builder().expression(String.valueOf(outputEntry.getExpression().getValue())).build();
        String mvelInputExpressionValue = this.expressionCache.computeIfAbsent(key, k -> this.expressionConverter.convert(((Key)k).expression, ((Key)k).inputName));
        Expression mvelInputExpression = (Expression)((Expression.Builder)((Expression.Builder)Expression.builder().type(outputEntry.getExpression().getType())).value((Serializable)((Object)mvelInputExpressionValue))).build();
        Serializable result = this.evaluate(mvelInputExpression, evaluationContext);
        log.debug("Evaluated output entry result: {}", (Object)result);
        return result;
    }

    Serializable evaluate(InputEntry inputEntry, EvaluationContext evaluationContext) {
        VariableResolverFactory mapVariableResolverFactory = this.fillVariables(evaluationContext);
        mapVariableResolverFactory.createVariable(inputEntry.getNameAlias(), (Object)evaluationContext.get(inputEntry.getName()));
        Key key = Key.builder().expression(String.valueOf(inputEntry.getExpression().getValue())).inputName(inputEntry.getName()).build();
        String mvelExpressionValue = this.expressionCache.computeIfAbsent(key, k -> this.expressionConverter.convert(((Key)k).expression, ((Key)k).inputName));
        Expression mvelInputEntryExpression = (Expression)((Expression.Builder)((Expression.Builder)Expression.builder().type(inputEntry.getExpression().getType())).value((Serializable)((Object)mvelExpressionValue))).build();
        return this.evaluate(mvelInputEntryExpression, mapVariableResolverFactory);
    }

    private static class Key
    implements Serializable {
        private final String expression;
        private final String inputName;

        @Generated
        Key(String expression, String inputName) {
            this.expression = expression;
            this.inputName = inputName;
        }

        @Generated
        public static KeyBuilder builder() {
            return new KeyBuilder();
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$expression = this.expression;
            String other$expression = other.expression;
            if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
                return false;
            }
            String this$inputName = this.inputName;
            String other$inputName = other.inputName;
            return !(this$inputName == null ? other$inputName != null : !this$inputName.equals(other$inputName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Key;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $expression = this.expression;
            result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
            String $inputName = this.inputName;
            result = result * 59 + ($inputName == null ? 43 : $inputName.hashCode());
            return result;
        }

        @Generated
        public static class KeyBuilder {
            @Generated
            private String expression;
            @Generated
            private String inputName;

            @Generated
            KeyBuilder() {
            }

            @Generated
            public KeyBuilder expression(String expression) {
                this.expression = expression;
                return this;
            }

            @Generated
            public KeyBuilder inputName(String inputName) {
                this.inputName = inputName;
                return this;
            }

            @Generated
            public Key build() {
                return new Key(this.expression, this.inputName);
            }

            @Generated
            public String toString() {
                return "FeelExpressionEvaluationProvider.Key.KeyBuilder(expression=" + this.expression + ", inputName=" + this.inputName + ")";
            }
        }
    }
}

