/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.io.xml;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.JAXBIntrospector;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import lombok.Generated;
import org.powerflows.dmn.engine.model.decision.Decision;
import org.powerflows.dmn.engine.reader.DecisionReadException;
import org.powerflows.dmn.engine.reader.DecisionReader;
import org.powerflows.dmn.io.xml.XmlDecisionConverter;
import org.powerflows.dmn.io.xml.model.XmlDecision;
import org.powerflows.dmn.io.xml.model.XmlDefinitions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlDecisionReader
implements DecisionReader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(XmlDecisionReader.class);
    private final XMLInputFactory factory;
    private final JAXBContext decisionContext;
    private final XmlDecisionConverter converter = new XmlDecisionConverter();
    private final boolean strict;

    public XmlDecisionReader() {
        this(false);
    }

    public XmlDecisionReader(boolean strict) {
        this.factory = XMLInputFactory.newInstance();
        this.factory.setProperty("javax.xml.stream.supportDTD", false);
        this.strict = strict;
        try {
            this.decisionContext = JAXBContext.newInstance((Class[])new Class[]{XmlDefinitions.class});
        }
        catch (JAXBException e) {
            throw new DecisionReadException("Unable to instantiate JAXB context", (Throwable)e);
        }
    }

    public Optional<Decision> read(InputStream inputStream) {
        return this.readAll(inputStream).stream().findFirst();
    }

    public Optional<Decision> read(InputStream inputStream, String decisionId) {
        return this.readAll(inputStream).stream().filter(decision -> Objects.equals(decision.getId(), decisionId)).findFirst();
    }

    public List<Decision> readAll(InputStream inputStream) {
        try {
            ArrayList<XmlDecision> results = new ArrayList<XmlDecision>();
            this.doReadDecisionsStream(this.factory.createXMLStreamReader(inputStream), results::add);
            return this.convert(results);
        }
        catch (JAXBException | XMLStreamException e) {
            throw new DecisionReadException("Unable to read decision", e);
        }
    }

    private List<Decision> convert(List<XmlDecision> results) {
        return results.stream().filter(d -> d.getDecisionTable() != null).map(this.converter::from).collect(Collectors.toList());
    }

    private Unmarshaller getUnmarshaller() {
        try {
            Unmarshaller decisionUnmarshaller = this.decisionContext.createUnmarshaller();
            if (this.strict) {
                decisionUnmarshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
            }
            return decisionUnmarshaller;
        }
        catch (JAXBException e) {
            throw new DecisionReadException("Error creating unmarshaller", (Throwable)e);
        }
    }

    private void doReadDecisionsStream(XMLStreamReader r, Consumer<XmlDecision> decisionConsumer) throws XMLStreamException, JAXBException {
        Unmarshaller decisionUnmarshaller = this.getUnmarshaller();
        XmlDefinitions definitions = (XmlDefinitions)JAXBIntrospector.getValue((Object)decisionUnmarshaller.unmarshal(r, XmlDefinitions.class));
        log.trace("Read XML document: {}", (Object)definitions);
        definitions.getDecisions().forEach(decisionConsumer);
        r.close();
    }
}

