/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.io.yaml;

import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.powerflows.dmn.engine.model.decision.Decision;
import org.powerflows.dmn.engine.reader.DecisionReadException;
import org.powerflows.dmn.engine.reader.DecisionReader;
import org.powerflows.dmn.io.yaml.CustomConstructor;
import org.powerflows.dmn.io.yaml.YamlDecisionConverter;
import org.powerflows.dmn.io.yaml.model.YamlDecision;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;

public class YamlDecisionReader
implements DecisionReader {
    public static final String UNABLE_TO_READ_FROM_STREAM = "Unable to read from stream";
    private final Yaml yaml = new Yaml((BaseConstructor)new CustomConstructor());
    private final YamlDecisionConverter converter = new YamlDecisionConverter();

    public List<Decision> readAll(InputStream inputStream) {
        try {
            return StreamSupport.stream(this.yaml.loadAll(inputStream).spliterator(), true).map(o -> (YamlDecision)o).map(this.converter::from).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new DecisionReadException(UNABLE_TO_READ_FROM_STREAM, (Throwable)e);
        }
    }

    public Optional<Decision> read(InputStream inputStream) {
        try {
            return Optional.of((YamlDecision)this.yaml.load(inputStream)).map(this.converter::from);
        }
        catch (Exception e) {
            throw new DecisionReadException(UNABLE_TO_READ_FROM_STREAM, (Throwable)e);
        }
    }

    public Optional<Decision> read(InputStream inputStream, String decisionId) {
        try {
            return StreamSupport.stream(this.yaml.loadAll(inputStream).spliterator(), true).map(o -> (YamlDecision)o).filter(d -> decisionId.equals(d.getId())).map(this.converter::from).findFirst();
        }
        catch (Exception e) {
            throw new DecisionReadException(UNABLE_TO_READ_FROM_STREAM, (Throwable)e);
        }
    }
}

