/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.io.yaml;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.powerflows.dmn.engine.model.decision.Decision;
import org.powerflows.dmn.engine.writer.DecisionWriteException;
import org.powerflows.dmn.engine.writer.DecisionWriter;
import org.powerflows.dmn.io.yaml.CustomRepresenter;
import org.powerflows.dmn.io.yaml.YamlDecisionConverter;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.representer.Representer;

public class YamlDecisionWriter
implements DecisionWriter {
    private final Yaml yaml;
    private final YamlDecisionConverter converter = new YamlDecisionConverter();

    public YamlDecisionWriter() {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setPrettyFlow(true);
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.yaml = new Yaml((Representer)new CustomRepresenter(), dumperOptions);
    }

    public void write(Decision decision, OutputStream outputStream) {
        try {
            this.yaml.dump((Object)this.converter.to(decision), this.createWriter(outputStream));
        }
        catch (Exception e) {
            throw new DecisionWriteException("Unable to write decision: " + decision, (Throwable)e);
        }
    }

    public void writeAll(Iterable<Decision> decisions, OutputStream outputStream) {
        try {
            this.yaml.dumpAll(StreamSupport.stream(decisions.spliterator(), false).map(this.converter::to).collect(Collectors.toList()).iterator(), this.createWriter(outputStream));
        }
        catch (Exception e) {
            throw new DecisionWriteException("Unable to write decision: " + decisions, (Throwable)e);
        }
    }

    private Writer createWriter(OutputStream outputStream) {
        return new BufferedWriter(new OutputStreamWriter(outputStream));
    }
}

