/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.evaluator.expression.provider;

import de.odysseus.el.ExpressionFactoryImpl;
import java.io.Serializable;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import lombok.Generated;
import org.powerflows.dmn.engine.evaluator.context.EvaluationContext;
import org.powerflows.dmn.engine.evaluator.expression.ExpressionEvaluationException;
import org.powerflows.dmn.engine.evaluator.expression.provider.ExpressionEvaluationConfiguration;
import org.powerflows.dmn.engine.evaluator.expression.provider.ExpressionEvaluationProvider;
import org.powerflows.dmn.engine.evaluator.expression.provider.juel.BasicELContext;
import org.powerflows.dmn.engine.evaluator.expression.provider.juel.MethodBindingListFunctionMapper;
import org.powerflows.dmn.engine.model.decision.field.Input;
import org.powerflows.dmn.engine.model.decision.rule.entry.InputEntry;
import org.powerflows.dmn.engine.model.decision.rule.entry.OutputEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JuelExpressionEvaluationProvider
implements ExpressionEvaluationProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JuelExpressionEvaluationProvider.class);
    private final ExpressionFactory expressionFactory = new ExpressionFactoryImpl();
    private final FunctionMapper rootFunctionMapper;

    JuelExpressionEvaluationProvider(ExpressionEvaluationConfiguration configuration) {
        this.rootFunctionMapper = new MethodBindingListFunctionMapper(configuration.getMethodBindings());
    }

    public Serializable evaluateInput(Input input, EvaluationContext evaluationContext) {
        log.debug("Starting evaluation of input: {} with evaluation context: {}", (Object)input, (Object)evaluationContext);
        Serializable result = this.evaluate((String)((Object)input.getExpression().getValue()), input.getType().realType(), this.makeContext(evaluationContext));
        log.debug("Evaluated result: {}", (Object)result);
        return result;
    }

    public Serializable evaluateInputEntry(InputEntry inputEntry, EvaluationContext evaluationContext) {
        log.debug("Starting evaluation of input entry {} with evaluation context: {}", (Object)inputEntry, (Object)evaluationContext);
        Serializable result = this.evaluate((String)((Object)inputEntry.getExpression().getValue()), Serializable.class, this.makeContext(evaluationContext, inputEntry));
        log.debug("Evaluated entry result: {}", (Object)result);
        return result;
    }

    public Serializable evaluateOutputEntry(OutputEntry outputEntry, EvaluationContext evaluationContext) {
        log.debug("Starting evaluation of output entry {} with evaluation context: {}", (Object)outputEntry, (Object)evaluationContext);
        Serializable result = this.evaluate((String)((Object)outputEntry.getExpression().getValue()), Serializable.class, this.makeContext(evaluationContext));
        log.debug("Evaluated entry result: {}", (Object)result);
        return result;
    }

    private BasicELContext makeContext(EvaluationContext evaluationContext) {
        BasicELContext context = new BasicELContext(this.rootFunctionMapper);
        evaluationContext.getAll().forEach((key, value) -> context.setVariable((String)key, this.expressionFactory.createValueExpression(value, value == null ? Object.class : value.getClass())));
        return context;
    }

    private ELContext makeContext(EvaluationContext evaluationContext, InputEntry inputEntry) {
        BasicELContext context = this.makeContext(evaluationContext);
        context.setVariable(inputEntry.getNameAlias(), context.getVariableMapper().resolveVariable(inputEntry.getName()));
        return context;
    }

    private Serializable evaluate(String expressionText, Class<? extends Serializable> targetType, ELContext evaluationContext) {
        try {
            return (Serializable)this.expressionFactory.createValueExpression(evaluationContext, "${" + expressionText + "}", targetType).getValue(evaluationContext);
        }
        catch (ELException e) {
            throw new ExpressionEvaluationException("Error evaluating expression - " + expressionText, (Exception)((Object)e));
        }
    }
}

