/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.configuration;

import org.powerflows.dmn.engine.DecisionEngine;
import org.powerflows.dmn.engine.DefaultDecisionEngine;
import org.powerflows.dmn.engine.configuration.AbstractDecisionEngineConfiguration;
import org.powerflows.dmn.engine.evaluator.decision.DecisionEvaluator;
import org.powerflows.dmn.engine.evaluator.entry.EntryEvaluator;
import org.powerflows.dmn.engine.evaluator.entry.InputEntryEvaluator;
import org.powerflows.dmn.engine.evaluator.entry.OutputEntryEvaluator;
import org.powerflows.dmn.engine.evaluator.entry.expression.provider.EvaluationProviderFactory;
import org.powerflows.dmn.engine.evaluator.rule.RuleEvaluator;

public class DefaultDecisionEngineConfiguration
extends AbstractDecisionEngineConfiguration {
    private DecisionEvaluator decisionEvaluator;
    private RuleEvaluator ruleEvaluator;
    private EntryEvaluator entryEvaluator;
    private InputEntryEvaluator inputEntryEvaluator;
    private OutputEntryEvaluator outputEntryEvaluator;
    private EvaluationProviderFactory evaluationProviderFactory;

    @Override
    public DecisionEngine configure() {
        this.initEvaluationProviderFactory();
        this.initInputEntryEvaluator();
        this.initOutputEntryEvaluator();
        this.initEntryEvaluator();
        this.initRuleEvaluator();
        this.initDecisionEvaluator();
        return new DefaultDecisionEngine(this.decisionEvaluator);
    }

    private void initEvaluationProviderFactory() {
        this.evaluationProviderFactory = new EvaluationProviderFactory();
    }

    private void initInputEntryEvaluator() {
        this.inputEntryEvaluator = new InputEntryEvaluator(this.evaluationProviderFactory);
    }

    private void initOutputEntryEvaluator() {
        this.outputEntryEvaluator = new OutputEntryEvaluator(this.evaluationProviderFactory);
    }

    private void initEntryEvaluator() {
        this.entryEvaluator = new EntryEvaluator(this.inputEntryEvaluator, this.outputEntryEvaluator);
    }

    private void initRuleEvaluator() {
        this.ruleEvaluator = new RuleEvaluator(this.entryEvaluator);
    }

    private void initDecisionEvaluator() {
        this.decisionEvaluator = new DecisionEvaluator(this.ruleEvaluator);
    }
}

