/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.evaluator.decision;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.powerflows.dmn.engine.evaluator.context.ModifiableContextVariables;
import org.powerflows.dmn.engine.evaluator.exception.EvaluationException;
import org.powerflows.dmn.engine.evaluator.rule.RuleEvaluator;
import org.powerflows.dmn.engine.model.decision.Decision;
import org.powerflows.dmn.engine.model.decision.HitPolicy;
import org.powerflows.dmn.engine.model.decision.field.Input;
import org.powerflows.dmn.engine.model.decision.rule.Rule;
import org.powerflows.dmn.engine.model.evaluation.context.ContextVariables;
import org.powerflows.dmn.engine.model.evaluation.result.DecisionResult;
import org.powerflows.dmn.engine.model.evaluation.result.RuleResult;

public class DecisionEvaluator {
    private final RuleEvaluator ruleEvaluator;

    public DecisionEvaluator(RuleEvaluator ruleEvaluator) {
        this.ruleEvaluator = ruleEvaluator;
    }

    public DecisionResult evaluate(Decision decision, ContextVariables contextVariables) {
        if (decision == null) {
            throw new NullPointerException("Decision can not be null.");
        }
        if (contextVariables == null) {
            throw new NullPointerException("Context variables can not be null.");
        }
        this.validateContextVariables(decision.getInputs(), contextVariables);
        ArrayList<RuleResult> ruleResults = new ArrayList<RuleResult>();
        boolean singleNonUniqueRuleResultExpected = this.isSingleNonUniqueRuleResultExpected(decision);
        Map<String, Input> inputs = decision.getInputs().stream().collect(Collectors.toMap(Input::getName, Function.identity()));
        ModifiableContextVariables modifiableContextVariables = new ModifiableContextVariables(contextVariables);
        for (Rule rule : decision.getRules()) {
            RuleResult ruleResult = this.ruleEvaluator.evaluate(rule, inputs, modifiableContextVariables);
            if (ruleResult == null) continue;
            ruleResults.add(ruleResult);
            if (!singleNonUniqueRuleResultExpected) continue;
            break;
        }
        if (this.isUniqueRuleResultExpected(decision) && this.isNonUniqueRuleResult(ruleResults)) {
            throw new EvaluationException("Unique result is expected");
        }
        DecisionResult decisionResult = (DecisionResult)DecisionResult.builder().ruleResults(ruleResults).build();
        return decisionResult;
    }

    private void validateContextVariables(List<Input> inputs, ContextVariables contextVariables) {
        String invalidInputNames = inputs.stream().filter(input -> input.getExpression().getValue() != null).filter(input -> contextVariables.isPresent(input.getName())).map(Input::getName).collect(Collectors.joining(","));
        if (!invalidInputNames.isEmpty()) {
            throw new EvaluationException("Can not apply context variables to inputs '" + invalidInputNames + "'. Only to inputs with literal expression possible.");
        }
    }

    private boolean isSingleNonUniqueRuleResultExpected(Decision decision) {
        return HitPolicy.FIRST.equals((Object)decision.getHitPolicy()) || HitPolicy.ANY.equals((Object)decision.getHitPolicy());
    }

    private boolean isUniqueRuleResultExpected(Decision decision) {
        return HitPolicy.UNIQUE.equals((Object)decision.getHitPolicy());
    }

    private boolean isCollectionRulesResultExpected(Decision decision) {
        return HitPolicy.COLLECT.equals((Object)decision.getHitPolicy());
    }

    private boolean isNonUniqueRuleResult(List<RuleResult> ruleResults) {
        return ruleResults.size() > 1;
    }
}

