/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.evaluator.entry.expression.provider;

import java.util.HashMap;
import java.util.Map;
import org.powerflows.dmn.engine.evaluator.entry.expression.provider.ExpressionEvaluationProvider;
import org.powerflows.dmn.engine.evaluator.entry.expression.provider.FeelExpressionEvaluationProvider;
import org.powerflows.dmn.engine.evaluator.entry.expression.provider.GroovyExpressionEvaluationProvider;
import org.powerflows.dmn.engine.evaluator.entry.expression.provider.JuelExpressionEvaluationProvider;
import org.powerflows.dmn.engine.evaluator.entry.expression.provider.LiteralExpressionEvaluationProvider;
import org.powerflows.dmn.engine.model.decision.expression.ExpressionType;

public class EvaluationProviderFactory {
    private final Map<ExpressionType, ExpressionEvaluationProvider> factories = new HashMap<ExpressionType, ExpressionEvaluationProvider>();

    public EvaluationProviderFactory() {
        this.factories.put(ExpressionType.LITERAL, new LiteralExpressionEvaluationProvider());
        this.factories.put(ExpressionType.FEEL, new FeelExpressionEvaluationProvider());
        this.factories.put(ExpressionType.JUEL, new JuelExpressionEvaluationProvider());
        this.factories.put(ExpressionType.GROOVY, new GroovyExpressionEvaluationProvider());
    }

    public ExpressionEvaluationProvider getInstance(ExpressionType expressionType) {
        ExpressionEvaluationProvider expressionEvaluationProvider = this.factories.get((Object)expressionType);
        if (expressionEvaluationProvider == null) {
            throw new IllegalArgumentException("Unknown expression type.");
        }
        return expressionEvaluationProvider;
    }
}

