/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.evaluator.expression.provider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.powerflows.dmn.engine.evaluator.exception.EvaluationException;
import org.powerflows.dmn.engine.evaluator.expression.provider.ExpressionEvaluationConfiguration;
import org.powerflows.dmn.engine.evaluator.expression.provider.ExpressionEvaluationProvider;
import org.powerflows.dmn.engine.evaluator.expression.provider.ExpressionEvaluationProviderFactory;
import org.powerflows.dmn.engine.evaluator.expression.provider.FeelExpressionEvaluationProvider;
import org.powerflows.dmn.engine.evaluator.expression.provider.binding.MethodBinding;
import org.powerflows.dmn.engine.evaluator.expression.provider.binding.StaticMethodBinding;
import org.powerflows.dmn.engine.evaluator.expression.provider.feel.function.DateAndTime;
import org.powerflows.dmn.engine.model.decision.expression.ExpressionType;

public class FeelExpressionEvaluationProviderFactory
implements ExpressionEvaluationProviderFactory {
    private static final List<ExpressionType> SUPPORTED = Collections.singletonList(ExpressionType.FEEL);

    @Override
    public ExpressionEvaluationProvider createProvider(ExpressionEvaluationConfiguration configuration) {
        ArrayList<MethodBinding> feelMethodBindings = new ArrayList<MethodBinding>(configuration.getMethodBindings());
        try {
            feelMethodBindings.add(new StaticMethodBinding("date and time", DateAndTime.class.getMethod("execute", String.class)));
        }
        catch (NoSuchMethodException e) {
            throw new EvaluationException("Can not bind feel function", e);
        }
        ExpressionEvaluationConfiguration feelConfiguration = ExpressionEvaluationConfiguration.builder().methodBindings(feelMethodBindings).scriptEngineManager(configuration.getScriptEngineManager()).build();
        return new FeelExpressionEvaluationProvider(feelConfiguration);
    }

    @Override
    public List<ExpressionType> supportedExpressionTypes() {
        return SUPPORTED;
    }
}

