/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.evaluator.expression.provider.feel.converter.mvel;

import java.util.ArrayList;
import java.util.stream.Collectors;
import org.powerflows.dmn.engine.evaluator.expression.provider.binding.ExpressionEvaluationException;
import org.powerflows.dmn.engine.evaluator.expression.provider.feel.converter.ExpressionConverter;

public class FeelToMvelCollectionExpressionConverter
implements ExpressionConverter {
    private final String collectionPattern = ",(?=([^\"]*\"[^\"]*\")*[^\"]*$)";
    private final ExpressionConverter feelToMvelUnaryExpressionConverter;

    FeelToMvelCollectionExpressionConverter(ExpressionConverter feelToMvelUnaryExpressionConverter) {
        this.feelToMvelUnaryExpressionConverter = feelToMvelUnaryExpressionConverter;
    }

    @Override
    public String convert(String feelExpression, String inputName) {
        if (inputName == null) {
            throw new ExpressionEvaluationException("Can not evaluate feel expression '" + feelExpression + "', due to applicable only for input entry expressions");
        }
        String[] expressions = feelExpression.split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)", -1);
        ArrayList<String> mvelExpressions = new ArrayList<String>();
        for (String expression : expressions) {
            String trimmedFeelExpression = expression.trim();
            if (trimmedFeelExpression.isEmpty()) {
                throw new ExpressionEvaluationException("Can not evaluate feel expression '" + feelExpression + "'");
            }
            String mvelExpression = this.feelToMvelUnaryExpressionConverter.convert(trimmedFeelExpression, inputName);
            mvelExpressions.add(mvelExpression);
        }
        return mvelExpressions.stream().collect(Collectors.joining(" || "));
    }

    @Override
    public boolean isConvertible(String feelExpression) {
        return feelExpression.split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)", -1).length > 1;
    }
}

