/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.evaluator.expression.provider.feel.converter.mvel;

import java.util.List;
import org.powerflows.dmn.engine.evaluator.expression.provider.binding.ExpressionEvaluationException;
import org.powerflows.dmn.engine.evaluator.expression.provider.binding.MethodBinding;
import org.powerflows.dmn.engine.evaluator.expression.provider.feel.converter.ExpressionConverter;

public class FeelToMvelFunctionExpressionConverter
implements ExpressionConverter {
    private final List<MethodBinding> functions;

    FeelToMvelFunctionExpressionConverter(List<MethodBinding> functions) {
        this.functions = functions;
    }

    @Override
    public String convert(String feelExpression, String inputName) {
        String functionName = this.functions.stream().filter(methodBinding -> this.replaceWhiteChars(feelExpression).startsWith(this.replaceWhiteChars(methodBinding.name()))).findFirst().orElseThrow(() -> new ExpressionEvaluationException("No bound function for expression '" + feelExpression + "'")).name();
        String mvelExpression = feelExpression.replace(functionName, this.replaceWhiteChars(functionName));
        if (inputName != null) {
            mvelExpression = inputName + "==" + mvelExpression;
        }
        return mvelExpression;
    }

    @Override
    public boolean isConvertible(String feelExpression) {
        return this.functions.stream().anyMatch(methodBinding -> this.replaceWhiteChars(feelExpression).startsWith(this.replaceWhiteChars(methodBinding.name()) + "("));
    }

    private String replaceWhiteChars(String string) {
        return string.replaceAll("\\s", "");
    }
}

