/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.evaluator.expression.provider.feel.converter.mvel;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.powerflows.dmn.engine.evaluator.expression.provider.binding.ExpressionEvaluationException;
import org.powerflows.dmn.engine.evaluator.expression.provider.feel.converter.ExpressionConverter;

public class FeelToMvelNotExpressionConverter
implements ExpressionConverter {
    private final Pattern notPattern = Pattern.compile("^not\\((.+)\\)$");
    private final ExpressionConverter feelToMvelRangeExpressionConverter;
    private final ExpressionConverter feelToMvelCollectionExpressionConverter;

    FeelToMvelNotExpressionConverter(ExpressionConverter feelToMvelRangeExpressionConverter, ExpressionConverter feelToMvelCollectionExpressionConverter) {
        this.feelToMvelRangeExpressionConverter = feelToMvelRangeExpressionConverter;
        this.feelToMvelCollectionExpressionConverter = feelToMvelCollectionExpressionConverter;
    }

    @Override
    public String convert(String feelExpression, String inputName) {
        String mvelExpression;
        if (inputName == null) {
            throw new ExpressionEvaluationException("Can not evaluate feel expression '" + feelExpression + "', due to applicable only for input entry expressions");
        }
        Matcher matcher = this.notPattern.matcher(feelExpression);
        if (matcher.matches()) {
            String feelNotArgumentExpression = matcher.group(1);
            mvelExpression = this.feelToMvelCollectionExpressionConverter.isConvertible(feelNotArgumentExpression) ? "!(" + this.feelToMvelCollectionExpressionConverter.convert(feelNotArgumentExpression, inputName) + ")" : (this.feelToMvelRangeExpressionConverter.isConvertible(feelNotArgumentExpression) ? "!(" + this.feelToMvelRangeExpressionConverter.convert(feelNotArgumentExpression, inputName) + ")" : inputName + "!=" + feelNotArgumentExpression);
        } else {
            throw new ExpressionEvaluationException("Can not evaluate feel expression '" + feelExpression + "'");
        }
        return mvelExpression;
    }

    @Override
    public boolean isConvertible(String feelExpression) {
        return feelExpression.startsWith("not(");
    }
}

