/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.evaluator.rule;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.powerflows.dmn.engine.evaluator.context.EvaluationContext;
import org.powerflows.dmn.engine.evaluator.entry.InputEntryEvaluator;
import org.powerflows.dmn.engine.evaluator.entry.OutputEntryEvaluator;
import org.powerflows.dmn.engine.model.decision.field.Input;
import org.powerflows.dmn.engine.model.decision.field.Output;
import org.powerflows.dmn.engine.model.decision.rule.Rule;
import org.powerflows.dmn.engine.model.decision.rule.entry.InputEntry;
import org.powerflows.dmn.engine.model.decision.rule.entry.OutputEntry;
import org.powerflows.dmn.engine.model.evaluation.result.EntryResult;
import org.powerflows.dmn.engine.model.evaluation.result.RuleResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleEvaluator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RuleEvaluator.class);
    private final InputEntryEvaluator inputEntryEvaluator;
    private final OutputEntryEvaluator outputEntryEvaluator;

    public RuleEvaluator(InputEntryEvaluator inputEntryEvaluator, OutputEntryEvaluator outputEntryEvaluator) {
        this.inputEntryEvaluator = inputEntryEvaluator;
        this.outputEntryEvaluator = outputEntryEvaluator;
    }

    public RuleResult evaluate(Rule rule, Map<String, Input> inputs, Map<String, Output> outputs, EvaluationContext evaluationContext) {
        log.debug("Starting evaluation of rule: {} with inputs: {}, outputs: {} and evaluation context: {}", new Object[]{rule, inputs, outputs, evaluationContext});
        List<EntryResult> entryResults = this.evaluateRule(rule, inputs, outputs, evaluationContext);
        RuleResult ruleResult = entryResults.isEmpty() ? null : (RuleResult)RuleResult.builder().entryResults(entryResults).build();
        log.debug("Evaluated rule result: {}", (Object)ruleResult);
        return ruleResult;
    }

    private List<EntryResult> evaluateRule(Rule rule, Map<String, Input> inputs, Map<String, Output> outputs, EvaluationContext evaluationContext) {
        ArrayList<EntryResult> entryResults = new ArrayList<EntryResult>();
        boolean positive = true;
        for (InputEntry inputEntry : rule.getInputEntries()) {
            Input input;
            if (this.inputEntryEvaluator.evaluate(inputEntry, input = inputs.get(inputEntry.getName()), evaluationContext)) continue;
            positive = false;
            break;
        }
        if (positive) {
            for (OutputEntry outputEntry : rule.getOutputEntries()) {
                Output output = outputs.get(outputEntry.getName());
                EntryResult entryResult = this.outputEntryEvaluator.evaluate(outputEntry, output, evaluationContext);
                entryResults.add(entryResult);
            }
        }
        return Collections.unmodifiableList(entryResults);
    }
}

