/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.evaluator.type.converter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.powerflows.dmn.engine.evaluator.exception.EvaluationException;
import org.powerflows.dmn.engine.evaluator.type.converter.TypeConverter;
import org.powerflows.dmn.engine.evaluator.type.value.BooleanValue;
import org.powerflows.dmn.engine.evaluator.type.value.SpecifiedTypeValue;

public class BooleanConverter
implements TypeConverter<Boolean> {
    @Override
    public SpecifiedTypeValue<Boolean> convert(Object unspecifiedValue) {
        BooleanValue booleanTypeValue;
        if (unspecifiedValue == null) {
            Boolean booleanValue = null;
            booleanTypeValue = new BooleanValue(booleanValue);
        } else if (unspecifiedValue instanceof Collection) {
            List<Boolean> booleanValues = this.convertCollection((Collection)unspecifiedValue);
            booleanTypeValue = new BooleanValue(booleanValues);
        } else if (unspecifiedValue.getClass().isArray()) {
            List<Boolean> booleanValues = this.convertArray((Object[])unspecifiedValue);
            booleanTypeValue = new BooleanValue(booleanValues);
        } else {
            Boolean booleanValue = this.convertSingleObject(unspecifiedValue);
            booleanTypeValue = new BooleanValue(booleanValue);
        }
        return booleanTypeValue;
    }

    private List<Boolean> convertCollection(Collection<Object> unspecifiedValues) {
        return unspecifiedValues.stream().map(this::convertSingleObject).collect(Collectors.toList());
    }

    private List<Boolean> convertArray(Object[] unspecifiedValues) {
        return this.convertCollection(new ArrayList<Object>(Arrays.asList(unspecifiedValues)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Boolean convertSingleObject(Object unspecifiedValue) {
        boolean booleanValue;
        if (unspecifiedValue instanceof Boolean) {
            booleanValue = (Boolean)unspecifiedValue;
            return booleanValue;
        } else {
            if (!(unspecifiedValue instanceof String)) throw new EvaluationException("Value " + unspecifiedValue + " is not boolean");
            if ("true".equalsIgnoreCase((String)unspecifiedValue)) {
                booleanValue = true;
                return booleanValue;
            } else {
                if (!"false".equalsIgnoreCase((String)unspecifiedValue)) throw new EvaluationException("Value " + unspecifiedValue + " is not boolean");
                booleanValue = false;
            }
        }
        return booleanValue;
    }
}

