/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.evaluator.type.converter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.powerflows.dmn.engine.evaluator.exception.EvaluationException;
import org.powerflows.dmn.engine.evaluator.type.converter.TypeConverter;
import org.powerflows.dmn.engine.evaluator.type.value.DoubleValue;
import org.powerflows.dmn.engine.evaluator.type.value.SpecifiedTypeValue;

public class DoubleConverter
implements TypeConverter<Double> {
    @Override
    public SpecifiedTypeValue<Double> convert(Object unspecifiedValue) {
        DoubleValue doubleTypeValue;
        if (unspecifiedValue == null) {
            Double doubleValue = null;
            doubleTypeValue = new DoubleValue(doubleValue);
        } else if (unspecifiedValue instanceof Collection) {
            List<Double> doubleValues = this.convertCollection((Collection)unspecifiedValue);
            doubleTypeValue = new DoubleValue(doubleValues);
        } else if (unspecifiedValue.getClass().isArray()) {
            List<Double> doubleValues = this.convertArray((Object[])unspecifiedValue);
            doubleTypeValue = new DoubleValue(doubleValues);
        } else {
            Double doubleValue = this.convertSingleObject(unspecifiedValue);
            doubleTypeValue = new DoubleValue(doubleValue);
        }
        return doubleTypeValue;
    }

    private List<Double> convertCollection(Collection<Object> unspecifiedValues) {
        return unspecifiedValues.stream().map(this::convertSingleObject).collect(Collectors.toList());
    }

    private List<Double> convertArray(Object[] unspecifiedValues) {
        return this.convertCollection(new ArrayList<Object>(Arrays.asList(unspecifiedValues)));
    }

    private Double convertSingleObject(Object unspecifiedValue) {
        double doubleValue;
        if (unspecifiedValue instanceof Number) {
            doubleValue = ((Number)unspecifiedValue).doubleValue();
        } else if (unspecifiedValue instanceof String) {
            doubleValue = Double.valueOf((String)unspecifiedValue);
        } else {
            throw new EvaluationException("Value " + unspecifiedValue + " is not double");
        }
        return doubleValue;
    }
}

