/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.evaluator.type.converter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.powerflows.dmn.engine.evaluator.type.converter.TypeConverter;
import org.powerflows.dmn.engine.evaluator.type.value.SpecifiedTypeValue;
import org.powerflows.dmn.engine.evaluator.type.value.StringValue;

public class StringConverter
implements TypeConverter<String> {
    @Override
    public SpecifiedTypeValue<String> convert(Object unspecifiedValue) {
        StringValue stringTypeValue;
        if (unspecifiedValue == null) {
            String stringValues = null;
            stringTypeValue = new StringValue(stringValues);
        } else if (unspecifiedValue instanceof Collection) {
            List<String> stringValues = this.convertCollection((Collection)unspecifiedValue);
            stringTypeValue = new StringValue(stringValues);
        } else if (unspecifiedValue.getClass().isArray()) {
            List<String> stringValues = this.convertArray((Object[])unspecifiedValue);
            stringTypeValue = new StringValue(stringValues);
        } else {
            String stringValue = this.convertSingleObject(unspecifiedValue);
            stringTypeValue = new StringValue(stringValue);
        }
        return stringTypeValue;
    }

    private List<String> convertCollection(Collection<Object> unspecifiedValues) {
        return unspecifiedValues.stream().map(this::convertSingleObject).collect(Collectors.toList());
    }

    private List<String> convertArray(Object[] unspecifiedValues) {
        return this.convertCollection(new ArrayList<Object>(Arrays.asList(unspecifiedValues)));
    }

    private String convertSingleObject(Object unspecifiedValue) {
        return String.valueOf(unspecifiedValue);
    }
}

