/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.model.builder;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.powerflows.dmn.engine.model.builder.Buildable;
import org.powerflows.dmn.engine.model.decision.DecisionBuildException;

public abstract class AbstractBuilder<T>
implements Buildable<T> {
    protected T product;

    public AbstractBuilder() {
        this.initProduct();
    }

    protected abstract void initProduct();

    protected T assembleProduct() {
        return this.product;
    }

    @Override
    public final T build() {
        T temp = this.assembleProduct();
        if (temp == null) {
            throw new IllegalStateException("Only single build() call is allowed");
        }
        this.product = null;
        return temp;
    }

    protected void validateIsNonNull(Serializable value, String message) {
        if (Objects.isNull(value)) {
            throw new DecisionBuildException(message);
        }
    }

    protected void validateIsNonEmpty(List value, String message) {
        if (value.isEmpty()) {
            throw new DecisionBuildException(message);
        }
    }
}

