/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.configuration;

import javax.script.ScriptEngineManager;
import org.powerflows.dmn.engine.DecisionEngine;
import org.powerflows.dmn.engine.DefaultDecisionEngine;
import org.powerflows.dmn.engine.configuration.AbstractDecisionEngineConfiguration;
import org.powerflows.dmn.engine.evaluator.decision.DecisionEvaluator;
import org.powerflows.dmn.engine.evaluator.entry.EntryEvaluator;
import org.powerflows.dmn.engine.evaluator.entry.InputEntryEvaluator;
import org.powerflows.dmn.engine.evaluator.entry.OutputEntryEvaluator;
import org.powerflows.dmn.engine.evaluator.expression.provider.EvaluationProviderFactory;
import org.powerflows.dmn.engine.evaluator.expression.script.DefaultScriptEngineProvider;
import org.powerflows.dmn.engine.evaluator.expression.script.ScriptEngineProvider;
import org.powerflows.dmn.engine.evaluator.rule.RuleEvaluator;

public class DefaultDecisionEngineConfiguration
extends AbstractDecisionEngineConfiguration {
    private DecisionEvaluator decisionEvaluator;
    private RuleEvaluator ruleEvaluator;
    private EntryEvaluator entryEvaluator;
    private InputEntryEvaluator inputEntryEvaluator;
    private OutputEntryEvaluator outputEntryEvaluator;
    private ScriptEngineProvider scriptEngineProvider;
    private EvaluationProviderFactory evaluationProviderFactory;

    @Override
    public DecisionEngine configure() {
        this.initScriptEngineProvider();
        this.initEvaluationProviderFactory();
        this.initInputEntryEvaluator();
        this.initOutputEntryEvaluator();
        this.initEntryEvaluator();
        this.initRuleEvaluator();
        this.initDecisionEvaluator();
        return new DefaultDecisionEngine(this.decisionEvaluator);
    }

    private void initEvaluationProviderFactory() {
        this.evaluationProviderFactory = new EvaluationProviderFactory(this.scriptEngineProvider);
    }

    private void initScriptEngineProvider() {
        this.scriptEngineProvider = new DefaultScriptEngineProvider(new ScriptEngineManager());
    }

    private void initInputEntryEvaluator() {
        this.inputEntryEvaluator = new InputEntryEvaluator(this.evaluationProviderFactory);
    }

    private void initOutputEntryEvaluator() {
        this.outputEntryEvaluator = new OutputEntryEvaluator(this.evaluationProviderFactory);
    }

    private void initEntryEvaluator() {
        this.entryEvaluator = new EntryEvaluator(this.inputEntryEvaluator, this.outputEntryEvaluator);
    }

    private void initRuleEvaluator() {
        this.ruleEvaluator = new RuleEvaluator(this.entryEvaluator);
    }

    private void initDecisionEvaluator() {
        this.decisionEvaluator = new DecisionEvaluator(this.ruleEvaluator);
    }
}

