/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.evaluator.expression.provider;

import lombok.Generated;
import org.powerflows.dmn.engine.evaluator.context.ModifiableContextVariables;
import org.powerflows.dmn.engine.evaluator.expression.comparator.ObjectsComparator;
import org.powerflows.dmn.engine.evaluator.expression.provider.ExpressionEvaluationProvider;
import org.powerflows.dmn.engine.model.decision.field.Input;
import org.powerflows.dmn.engine.model.decision.rule.entry.InputEntry;
import org.powerflows.dmn.engine.model.decision.rule.entry.OutputEntry;
import org.powerflows.dmn.engine.model.evaluation.result.EntryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LiteralExpressionEvaluationProvider
implements ExpressionEvaluationProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LiteralExpressionEvaluationProvider.class);
    private final ObjectsComparator objectsComparator;

    public LiteralExpressionEvaluationProvider(ObjectsComparator objectsComparator) {
        this.objectsComparator = objectsComparator;
    }

    @Override
    public boolean evaluateInputEntry(InputEntry inputEntry, ModifiableContextVariables contextVariables) {
        log.debug("Starting evaluation of input entry: {} with context variables: {}", (Object)inputEntry, (Object)contextVariables);
        Object inputValue = contextVariables.get(inputEntry.getName());
        Object inputEntryValue = inputEntry.getExpression().getValue();
        boolean result = this.objectsComparator.isInputEntryValueEqualInputValue(inputEntryValue, inputValue);
        log.debug("Evaluated input entry result: {}", (Object)result);
        return result;
    }

    @Override
    public Object evaluateInput(Input input, ModifiableContextVariables contextVariables) {
        log.debug("Starting evaluation of input: {} with context variables: {}", (Object)input, (Object)contextVariables);
        Object value = contextVariables.get(input.getName());
        if (value == null) {
            log.warn("Input value is null");
        }
        log.debug("Evaluated input result: {}", value);
        return value;
    }

    @Override
    public EntryResult evaluateOutputEntry(OutputEntry outputEntry, ModifiableContextVariables contextVariables) {
        log.debug("Starting evaluation of output entry: {} with context variables: {}", (Object)outputEntry, (Object)contextVariables);
        Object outputEntryValue = outputEntry.getExpression().getValue();
        EntryResult entryResult = (EntryResult)EntryResult.builder().name(outputEntry.getName()).value(outputEntryValue).build();
        log.debug("Evaluated output result: {}", (Object)entryResult);
        return entryResult;
    }
}

