/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.evaluator.expression.provider;

import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import lombok.Generated;
import org.powerflows.dmn.engine.evaluator.context.ModifiableContextVariables;
import org.powerflows.dmn.engine.evaluator.exception.EvaluationException;
import org.powerflows.dmn.engine.evaluator.expression.comparator.ObjectsComparator;
import org.powerflows.dmn.engine.evaluator.expression.provider.ExpressionEvaluationProvider;
import org.powerflows.dmn.engine.evaluator.expression.script.ScriptEngineProvider;
import org.powerflows.dmn.engine.evaluator.expression.script.bindings.ContextVariablesBindings;
import org.powerflows.dmn.engine.model.decision.expression.Expression;
import org.powerflows.dmn.engine.model.decision.field.Input;
import org.powerflows.dmn.engine.model.decision.rule.entry.InputEntry;
import org.powerflows.dmn.engine.model.decision.rule.entry.OutputEntry;
import org.powerflows.dmn.engine.model.evaluation.result.EntryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ScriptExpressionEvaluationProvider
implements ExpressionEvaluationProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScriptExpressionEvaluationProvider.class);
    private final ScriptEngineProvider scriptEngineProvider;
    private final ObjectsComparator objectsComparator;

    public ScriptExpressionEvaluationProvider(ScriptEngineProvider scriptEngineProvider, ObjectsComparator objectsComparator) {
        this.scriptEngineProvider = scriptEngineProvider;
        this.objectsComparator = objectsComparator;
    }

    @Override
    public boolean evaluateInputEntry(InputEntry inputEntry, ModifiableContextVariables contextVariables) {
        log.debug("Starting evaluation of input entry: {} with context variables: {}", (Object)inputEntry, (Object)contextVariables);
        Object inputValue = contextVariables.get(inputEntry.getName());
        Object inputEntryValue = this.evaluateValue(inputEntry.getExpression(), contextVariables);
        boolean result = this.objectsComparator.isInputEntryValueEqualInputValue(inputEntryValue, inputValue);
        log.debug("Evaluated input entry result: {}", (Object)result);
        return result;
    }

    @Override
    public Object evaluateInput(Input input, ModifiableContextVariables contextVariables) {
        log.debug("Starting evaluation of input: {} with context variables: {}", (Object)input, (Object)contextVariables);
        Object value = this.evaluateValue(input.getExpression(), contextVariables);
        log.debug("Evaluated input result: {}", value);
        return value;
    }

    @Override
    public EntryResult evaluateOutputEntry(OutputEntry outputEntry, ModifiableContextVariables contextVariables) {
        log.debug("Starting evaluation of output entry: {} with context variables: {}", (Object)outputEntry, (Object)contextVariables);
        Object outputEntryValue = this.evaluateValue(outputEntry.getExpression(), contextVariables);
        EntryResult entryResult = (EntryResult)EntryResult.builder().name(outputEntry.getName()).value(outputEntryValue).build();
        log.debug("Evaluated output result: {}", (Object)entryResult);
        return entryResult;
    }

    private Object evaluateValue(Expression expression, ModifiableContextVariables contextVariables) {
        Object value;
        ScriptEngine scriptEngine = this.scriptEngineProvider.getScriptEngine(expression.getType());
        ContextVariablesBindings bindings = ContextVariablesBindings.create(scriptEngine.createBindings(), contextVariables);
        try {
            value = scriptEngine.eval((String)expression.getValue(), (Bindings)bindings);
        }
        catch (ScriptException e) {
            throw new EvaluationException("Script evaluation exception", e);
        }
        return value;
    }
}

