/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.io.yaml;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.powerflows.dmn.engine.model.decision.Decision;
import org.powerflows.dmn.engine.model.decision.expression.Expression;
import org.powerflows.dmn.engine.model.decision.expression.ExpressionType;
import org.powerflows.dmn.engine.model.decision.field.Input;
import org.powerflows.dmn.engine.model.decision.field.Output;
import org.powerflows.dmn.engine.model.decision.rule.Rule;
import org.powerflows.dmn.engine.model.decision.rule.entry.InputEntry;
import org.powerflows.dmn.engine.model.decision.rule.entry.OutputEntry;
import org.powerflows.dmn.io.DecisionToExternalModelConverter;
import org.powerflows.dmn.io.yaml.model.YamlDecision;
import org.powerflows.dmn.io.yaml.model.field.YamlFields;
import org.powerflows.dmn.io.yaml.model.field.YamlInput;
import org.powerflows.dmn.io.yaml.model.field.YamlOutput;
import org.powerflows.dmn.io.yaml.model.rule.YamlRule;
import org.powerflows.dmn.io.yaml.model.rule.YamlRuleEntry;

public class YamlDecisionConverter
implements DecisionToExternalModelConverter<YamlDecision> {
    @Override
    public YamlDecision to(Decision decision) {
        YamlDecision yamlDecision = new YamlDecision();
        yamlDecision.setId(decision.getId());
        yamlDecision.setName(decision.getName());
        yamlDecision.setExpressionType(decision.getExpressionType());
        yamlDecision.setHitPolicy(decision.getHitPolicy());
        yamlDecision.setFields(this.createFields(decision.getInputs(), decision.getOutputs()));
        yamlDecision.setRules(decision.getRules().stream().map(this::ruleToYamlRule).collect(Collectors.toList()));
        return yamlDecision;
    }

    private YamlFields createFields(List<Input> inputs, List<Output> outputs) {
        YamlFields yamlFields = new YamlFields();
        LinkedHashMap<String, YamlInput> in = new LinkedHashMap<String, YamlInput>();
        yamlFields.setIn(in);
        LinkedHashMap<String, YamlOutput> out = new LinkedHashMap<String, YamlOutput>();
        yamlFields.setOut(out);
        inputs.forEach(input -> {
            YamlInput yamlInput = new YamlInput();
            yamlInput.setDescription(input.getDescription());
            yamlInput.setType(input.getType());
            if (input.getExpression() != null && input.getExpression().getValue() != null) {
                yamlInput.setExpression(input.getExpression().getValue());
                yamlInput.setExpressionType(input.getExpression().getType() == ExpressionType.LITERAL ? null : input.getExpression().getType());
            }
            in.put(input.getName(), yamlInput);
        });
        outputs.forEach(output -> {
            YamlOutput yamlOutput = new YamlOutput();
            yamlOutput.setDescription(output.getDescription());
            yamlOutput.setType(output.getType());
            out.put(output.getName(), yamlOutput);
        });
        return yamlFields;
    }

    private YamlRule ruleToYamlRule(Rule rule) {
        YamlRule yamlRule = new YamlRule();
        yamlRule.setDescription(rule.getDescription());
        LinkedHashMap<String, YamlRuleEntry> in = new LinkedHashMap<String, YamlRuleEntry>();
        yamlRule.setIn(in);
        LinkedHashMap<String, YamlRuleEntry> out = new LinkedHashMap<String, YamlRuleEntry>();
        yamlRule.setOut(out);
        rule.getInputEntries().forEach(inputEntry -> {
            YamlRuleEntry yamlRuleEntry = new YamlRuleEntry();
            yamlRuleEntry.setExpressionType(inputEntry.getExpression().getType());
            yamlRuleEntry.setExpression(inputEntry.getExpression().getValue());
            in.put(inputEntry.getName(), yamlRuleEntry);
        });
        rule.getOutputEntries().forEach(outputEntry -> {
            YamlRuleEntry yamlRuleOutput = new YamlRuleEntry();
            yamlRuleOutput.setExpressionType(outputEntry.getExpression().getType());
            yamlRuleOutput.setExpression(outputEntry.getExpression().getValue());
            out.put(outputEntry.getName(), yamlRuleOutput);
        });
        return yamlRule;
    }

    @Override
    public Decision from(YamlDecision model) {
        Decision.Builder builder = Decision.builder();
        ((Decision.Builder)((Decision.Builder)((Decision.Builder)builder.id(model.getId())).name(model.getName())).expressionType(model.getExpressionType())).hitPolicy(model.getHitPolicy());
        model.getFields().getIn().forEach((name, input) -> builder.withInput(inputBuilder -> (Input)((Input.Builder)((Input.Builder)((Input.Builder)inputBuilder.name((String)name)).type(input.getType())).description(input.getDescription())).withExpression(expressionBuilder -> (Expression)((Expression.Builder)((Expression.Builder)expressionBuilder.type(input.getExpressionType())).value(input.getExpression())).build()).build()));
        model.getFields().getOut().forEach((name, output) -> builder.withOutput(outpBuilder -> (Output)((Output.Builder)((Output.Builder)((Output.Builder)outpBuilder.name((String)name)).type(output.getType())).description(output.getDescription())).build()));
        model.getRules().forEach(rule -> builder.withRule(ruleBuilder -> {
            rule.getIn().forEach((name, input) -> ruleBuilder.withInputEntry(inputEntryBuilder -> (InputEntry)((InputEntry.Builder)inputEntryBuilder.name((String)name)).withExpression(expressionBuilder -> (Expression)((Expression.Builder)((Expression.Builder)expressionBuilder.type(input.getExpressionType())).value(input.getExpression())).build()).build()));
            rule.getOut().forEach((name, output) -> ruleBuilder.withOutputEntry(outputEntryBuilder -> (OutputEntry)((OutputEntry.Builder)outputEntryBuilder.name((String)name)).withExpression(expressionBuilder -> (Expression)((Expression.Builder)((Expression.Builder)expressionBuilder.type(output.getExpressionType())).value(output.getExpression())).build()).build()));
            return (Rule)((Rule.Builder)ruleBuilder.description(rule.getDescription())).build();
        }));
        return (Decision)builder.build();
    }
}

