/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.configuration;

import javax.script.ScriptEngineManager;
import org.powerflows.dmn.engine.DecisionEngine;
import org.powerflows.dmn.engine.DefaultDecisionEngine;
import org.powerflows.dmn.engine.configuration.DecisionEngineConfiguration;
import org.powerflows.dmn.engine.evaluator.decision.DecisionEvaluator;
import org.powerflows.dmn.engine.evaluator.entry.EntryEvaluator;
import org.powerflows.dmn.engine.evaluator.entry.InputEntryEvaluator;
import org.powerflows.dmn.engine.evaluator.entry.OutputEntryEvaluator;
import org.powerflows.dmn.engine.evaluator.expression.comparator.DefaultObjectsComparator;
import org.powerflows.dmn.engine.evaluator.expression.comparator.ObjectsComparator;
import org.powerflows.dmn.engine.evaluator.expression.provider.EvaluationProviderFactory;
import org.powerflows.dmn.engine.evaluator.expression.script.DefaultScriptEngineProvider;
import org.powerflows.dmn.engine.evaluator.expression.script.ScriptEngineProvider;
import org.powerflows.dmn.engine.evaluator.rule.RuleEvaluator;
import org.powerflows.dmn.engine.evaluator.type.converter.TypeConverterFactory;

public class DefaultDecisionEngineConfiguration
implements DecisionEngineConfiguration {
    private DecisionEvaluator decisionEvaluator;
    private RuleEvaluator ruleEvaluator;
    private EntryEvaluator entryEvaluator;
    private ObjectsComparator objectsComparator;
    private InputEntryEvaluator inputEntryEvaluator;
    private OutputEntryEvaluator outputEntryEvaluator;
    private ScriptEngineProvider scriptEngineProvider;
    private EvaluationProviderFactory evaluationProviderFactory;
    private TypeConverterFactory typeConverterFactory;

    @Override
    public DecisionEngine configure() {
        this.initScriptEngineProvider();
        this.initEvaluationProviderFactory();
        this.initTypeConverterFactory();
        this.initObjectsComparator();
        this.initInputEntryEvaluator();
        this.initOutputEntryEvaluator();
        this.initEntryEvaluator();
        this.initRuleEvaluator();
        this.initDecisionEvaluator();
        return new DefaultDecisionEngine(this.decisionEvaluator);
    }

    private void initEvaluationProviderFactory() {
        this.evaluationProviderFactory = new EvaluationProviderFactory(this.scriptEngineProvider);
    }

    private void initTypeConverterFactory() {
        this.typeConverterFactory = new TypeConverterFactory();
    }

    private void initScriptEngineProvider() {
        this.scriptEngineProvider = new DefaultScriptEngineProvider(new ScriptEngineManager());
    }

    private void initObjectsComparator() {
        this.objectsComparator = new DefaultObjectsComparator();
    }

    private void initInputEntryEvaluator() {
        this.inputEntryEvaluator = new InputEntryEvaluator(this.evaluationProviderFactory, this.typeConverterFactory, this.objectsComparator);
    }

    private void initOutputEntryEvaluator() {
        this.outputEntryEvaluator = new OutputEntryEvaluator(this.evaluationProviderFactory, this.typeConverterFactory);
    }

    private void initEntryEvaluator() {
        this.entryEvaluator = new EntryEvaluator(this.inputEntryEvaluator, this.outputEntryEvaluator);
    }

    private void initRuleEvaluator() {
        this.ruleEvaluator = new RuleEvaluator(this.entryEvaluator);
    }

    private void initDecisionEvaluator() {
        this.decisionEvaluator = new DecisionEvaluator(this.ruleEvaluator);
    }
}

