/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.evaluator.entry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.powerflows.dmn.engine.evaluator.context.ModifiableContextVariables;
import org.powerflows.dmn.engine.evaluator.entry.InputEntryEvaluator;
import org.powerflows.dmn.engine.evaluator.entry.OutputEntryEvaluator;
import org.powerflows.dmn.engine.model.decision.field.Input;
import org.powerflows.dmn.engine.model.decision.field.Output;
import org.powerflows.dmn.engine.model.decision.rule.entry.InputEntry;
import org.powerflows.dmn.engine.model.decision.rule.entry.OutputEntry;
import org.powerflows.dmn.engine.model.evaluation.result.EntryResult;

public class EntryEvaluator {
    private final InputEntryEvaluator inputEntryEvaluator;
    private final OutputEntryEvaluator outputEntryEvaluator;

    public EntryEvaluator(InputEntryEvaluator inputEntryEvaluator, OutputEntryEvaluator outputEntryEvaluator) {
        this.inputEntryEvaluator = inputEntryEvaluator;
        this.outputEntryEvaluator = outputEntryEvaluator;
    }

    public List<EntryResult> evaluate(List<InputEntry> inputEntries, List<OutputEntry> outputEntries, Map<String, Input> inputs, Map<String, Output> outputs, ModifiableContextVariables contextVariables) {
        ArrayList<EntryResult> entryResults = new ArrayList<EntryResult>();
        boolean positive = true;
        for (InputEntry inputEntry : inputEntries) {
            Input input;
            if (this.inputEntryEvaluator.evaluate(inputEntry, input = inputs.get(inputEntry.getName()), contextVariables)) continue;
            positive = false;
            break;
        }
        if (positive) {
            for (OutputEntry outputEntry : outputEntries) {
                Output output = outputs.get(outputEntry.getName());
                EntryResult entryResult = this.outputEntryEvaluator.evaluate(outputEntry, output, contextVariables);
                entryResults.add(entryResult);
            }
        }
        return Collections.unmodifiableList(entryResults);
    }
}

