/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.evaluator.entry;

import lombok.Generated;
import org.powerflows.dmn.engine.evaluator.context.ModifiableContextVariables;
import org.powerflows.dmn.engine.evaluator.expression.comparator.ObjectsComparator;
import org.powerflows.dmn.engine.evaluator.expression.provider.EvaluationProviderFactory;
import org.powerflows.dmn.engine.evaluator.expression.provider.ExpressionEvaluationProvider;
import org.powerflows.dmn.engine.evaluator.type.converter.TypeConverter;
import org.powerflows.dmn.engine.evaluator.type.converter.TypeConverterFactory;
import org.powerflows.dmn.engine.evaluator.type.value.SpecifiedTypeValue;
import org.powerflows.dmn.engine.model.decision.field.Input;
import org.powerflows.dmn.engine.model.decision.field.ValueType;
import org.powerflows.dmn.engine.model.decision.rule.entry.InputEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputEntryEvaluator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InputEntryEvaluator.class);
    private final EvaluationProviderFactory evaluationProviderFactory;
    private final TypeConverterFactory typeConverterFactory;
    private final ObjectsComparator objectsComparator;

    public InputEntryEvaluator(EvaluationProviderFactory evaluationProviderFactory, TypeConverterFactory typeConverterFactory, ObjectsComparator objectsComparator) {
        this.evaluationProviderFactory = evaluationProviderFactory;
        this.typeConverterFactory = typeConverterFactory;
        this.objectsComparator = objectsComparator;
    }

    public boolean evaluate(InputEntry inputEntry, Input input, ModifiableContextVariables contextVariables) {
        boolean result;
        ExpressionEvaluationProvider inputEntryExpressionEvaluator = this.evaluationProviderFactory.getInstance(inputEntry.getExpression().getType());
        TypeConverter typeConverter = this.typeConverterFactory.getInstance(input.getType());
        if (!this.isInputEvaluated(input, contextVariables)) {
            ExpressionEvaluationProvider inputExpressionEvaluator = this.evaluationProviderFactory.getInstance(input.getExpression().getType());
            Object evaluatedInputValue = inputExpressionEvaluator.evaluateInput(input, contextVariables);
            contextVariables.addVariable(input.getName(), evaluatedInputValue);
        }
        Object inputValue = contextVariables.get(inputEntry.getName());
        SpecifiedTypeValue typedInputValue = typeConverter.convert(inputValue);
        Object inputEntryValue = inputEntryExpressionEvaluator.evaluateEntry(inputEntry.getExpression(), contextVariables);
        if (!ValueType.BOOLEAN.equals((Object)input.getType())) {
            if (inputEntryValue.equals(Boolean.TRUE)) {
                result = true;
            } else if (inputEntryValue.equals(Boolean.FALSE)) {
                result = false;
            } else {
                SpecifiedTypeValue typedInputEntryValue = typeConverter.convert(inputEntryValue);
                result = this.objectsComparator.isInputEntryValueEqualInputValue(typedInputEntryValue, typedInputValue);
            }
        } else {
            SpecifiedTypeValue typedInputEntryValue = typeConverter.convert(inputEntryValue);
            result = this.objectsComparator.isInputEntryValueEqualInputValue(typedInputEntryValue, typedInputValue);
        }
        log.debug("Evaluated input entry result: {}", (Object)result);
        return result;
    }

    private boolean isInputEvaluated(Input input, ModifiableContextVariables contextVariables) {
        return contextVariables.isPresent(input.getName());
    }
}

