/*
 * Decompiled with CFR 0.152.
 */
package org.powerflows.dmn.engine.evaluator.expression.provider;

import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import lombok.Generated;
import org.powerflows.dmn.engine.evaluator.context.ModifiableContextVariables;
import org.powerflows.dmn.engine.evaluator.exception.EvaluationException;
import org.powerflows.dmn.engine.evaluator.expression.provider.ExpressionEvaluationProvider;
import org.powerflows.dmn.engine.evaluator.expression.script.ScriptEngineProvider;
import org.powerflows.dmn.engine.evaluator.expression.script.bindings.ContextVariablesBindings;
import org.powerflows.dmn.engine.model.decision.expression.Expression;
import org.powerflows.dmn.engine.model.decision.field.Input;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ScriptExpressionEvaluationProvider
implements ExpressionEvaluationProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScriptExpressionEvaluationProvider.class);
    private final ScriptEngineProvider scriptEngineProvider;

    public ScriptExpressionEvaluationProvider(ScriptEngineProvider scriptEngineProvider) {
        this.scriptEngineProvider = scriptEngineProvider;
    }

    @Override
    public Object evaluateInput(Input input, ModifiableContextVariables contextVariables) {
        log.debug("Starting evaluation of input: {} with context variables: {}", (Object)input, (Object)contextVariables);
        Object result = this.evaluate(input.getExpression(), contextVariables);
        log.debug("Evaluated result: {}", result);
        return result;
    }

    @Override
    public Object evaluateEntry(Expression entryExpression, ModifiableContextVariables contextVariables) {
        log.debug("Starting evaluation of entry with expression: {} and context variables: {}", (Object)entryExpression, (Object)contextVariables);
        Object result = this.evaluate(entryExpression, contextVariables);
        log.debug("Evaluated entry result: {}", result);
        return result;
    }

    private Object evaluate(Expression expression, ModifiableContextVariables contextVariables) {
        Object result;
        ScriptEngine scriptEngine = this.scriptEngineProvider.getScriptEngine(expression.getType());
        ContextVariablesBindings bindings = ContextVariablesBindings.create(scriptEngine.createBindings(), contextVariables);
        try {
            result = scriptEngine.eval((String)expression.getValue(), (Bindings)bindings);
        }
        catch (ScriptException e) {
            throw new EvaluationException("Script evaluation exception", e);
        }
        return result;
    }
}

